/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.helper.Codecs;
import org.cyclops.integrateddynamics.core.part.event.PartReaderAspectEvent;

public class PartReaderAspectTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Codecs.PART_TYPE.optionalFieldOf("parttype").forGetter(Instance::partType), (App)Codecs.ASPECT.optionalFieldOf("aspect").forGetter(Instance::aspect)).apply((Applicative)p_311401_, Instance::new));

    public PartReaderAspectTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void test(ServerPlayer player, PartReaderAspectEvent event) {
        this.trigger(player, instance -> instance.test(player, event));
    }

    @SubscribeEvent
    public void onEvent(PartReaderAspectEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer() instanceof ServerPlayer) {
            this.test((ServerPlayer)event.getEntityPlayer(), event);
        }
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<IPartType> partType, Optional<IAspect> aspect) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<PartReaderAspectEvent>
    {
        public boolean test(ServerPlayer player, PartReaderAspectEvent event) {
            return !(!this.partType.isEmpty() && event.getPartType() != this.partType.get() || !this.aspect.isEmpty() && event.getAspect() != this.aspect.get());
        }
    }
}

