/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.persist.world;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.TickHandler;

public class NetworkWorldStorage
extends WorldStorage {
    private static NetworkWorldStorage INSTANCE = null;
    @NBTPersist
    private Set<INetwork> networks = Sets.newHashSet();

    private NetworkWorldStorage(ModBase mod) {
        super(mod);
    }

    public static NetworkWorldStorage getInstance(ModBase mod) {
        if (INSTANCE == null) {
            INSTANCE = new NetworkWorldStorage(mod);
        }
        return INSTANCE;
    }

    public void reset() {
        this.networks.clear();
    }

    protected String getDataId() {
        return "Networks";
    }

    public synchronized void addNewNetwork(INetwork network) {
        this.networks.add(network);
    }

    public synchronized void removeInvalidatedNetwork(INetwork network) {
        this.networks.remove(network);
    }

    public synchronized Set<INetwork> getNetworks() {
        return Collections.unmodifiableSet(Sets.newHashSet(this.networks));
    }

    public void afterLoad() {
        TickHandler.getInstance().ticked = false;
        for (INetwork network : this.networks) {
            network.afterServerLoad();
        }
    }

    public void beforeSave() {
        for (INetwork network : this.networks) {
            network.beforeServerStop();
        }
    }
}

