/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.items;

import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import ironfurnaces.util.DirectionUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemFurnaceCopy
extends Item {
    public ItemFurnaceCopy(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        CompoundTag tag;
        CustomData customData = (CustomData)stack.get(Registration.FURNACE_SETTINGS.get());
        if (customData != null && !(tag = customData.copyTag()).isEmpty()) {
            int[] settings = tag.getIntArray("settings");
            tooltip.add((Component)Component.literal((String)("Down: " + settings[0])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("Up: " + settings[1])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("North: " + settings[2])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("South: " + settings[3])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("West: " + settings[4])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("East: " + settings[5])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("Auto Input: " + settings[6])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("Auto Output: " + settings[7])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("Redstone Mode: " + settings[8])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("Redstone Value: " + settings[9])).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.literal((String)("Direction: " + String.valueOf(DirectionUtil.fromId(tag.getInt("direction"))))).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)Component.literal((String)"Right-click to copy settings").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)"Sneak & right-click to apply settings").withStyle(ChatFormatting.GRAY));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (!ctx.getPlayer().isCrouching()) {
            return super.useOn(ctx);
        }
        if (!world.isClientSide) {
            CompoundTag tag;
            BlockEntity te = world.getBlockEntity(pos);
            if (!(te instanceof BlockIronFurnaceTileBase)) {
                return super.useOn(ctx);
            }
            ItemStack stack = ctx.getItemInHand();
            CustomData customData = (CustomData)stack.get(Registration.FURNACE_SETTINGS.get());
            if (customData != null && !(tag = customData.copyTag()).isEmpty()) {
                int[] settings = tag.getIntArray("settings");
                for (int i = 0; i < settings.length; ++i) {
                    ((BlockIronFurnaceTileBase)te).furnaceSettings.set(i, settings[i]);
                }
                Direction dir = DirectionUtil.fromId(tag.getInt("direction"));
                if (dir != Direction.UP && dir != Direction.DOWN && te.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != dir) {
                    te.getLevel().setBlock(te.getBlockPos(), (BlockState)te.getBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir), 3);
                }
            }
            world.markAndNotifyBlock(pos, world.getChunkAt(pos), world.getBlockState(pos).getBlock().defaultBlockState(), world.getBlockState(pos), 3, 3);
            ctx.getPlayer().sendSystemMessage((Component)Component.literal((String)"Settings applied"));
        }
        return super.useOn(ctx);
    }
}

