/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.SchoolFilteredAffix;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class SchoolAttributeAffix
extends AttributeAffix {
    public static final Codec<SchoolAttributeAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)LootRarity.mapCodec((Codec)StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories), (App)ResourceLocation.CODEC.optionalFieldOf("school").forGetter(a -> a.schoolIds.filter(list -> list.size() == 1).map(list -> (ResourceLocation)list.get(0))), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("schools").forGetter(a -> a.schoolIds)).apply((Applicative)inst, (def, attr, op, values, categories, singleSchool, schoolsArray) -> {
        Optional<List<ResourceLocation>> schoolIds = schoolsArray.isPresent() ? schoolsArray : singleSchool.map(List::of);
        return new SchoolAttributeAffix((AffixDefinition)def, (Holder<Attribute>)attr, (AttributeModifier.Operation)op, (Map<LootRarity, StepFunction>)values, (Set<LootCategory>)categories, schoolIds);
    }));
    protected final Optional<List<ResourceLocation>> schoolIds;
    protected final Optional<Set<SchoolType>> schools;

    public SchoolAttributeAffix(AffixDefinition def, Holder<Attribute> attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values, Set<LootCategory> categories, Optional<List<ResourceLocation>> schoolIds) {
        super(def, attr, op, values, categories);
        this.schoolIds = schoolIds;
        this.schools = schoolIds.map(ids -> {
            HashSet<SchoolType> schoolSet = new HashSet<SchoolType>();
            for (ResourceLocation id : ids) {
                SchoolType s = (SchoolType)SchoolRegistry.REGISTRY.get(id);
                if (s != null) {
                    schoolSet.add(s);
                    continue;
                }
                Apotheosis.LOGGER.warn("Unknown school ID {} provided for SchoolAttributeAffix, ignoring.", (Object)id);
            }
            return schoolSet;
        });
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (!super.canApplyTo(stack, cat, rarity)) {
            return false;
        }
        if (cat == null || cat.isNone()) {
            return false;
        }
        return SchoolFilteredAffix.matchesSchools(stack, this.schools);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

