/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.SchoolFilteredAffix;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class SpellLevelAffix
extends SchoolFilteredAffix {
    public static final Codec<SpellLevelAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)ResourceLocation.CODEC.optionalFieldOf("school").forGetter(a -> a.schoolIds.filter(list -> list.size() == 1).map(list -> (ResourceLocation)list.get(0))), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("schools").forGetter(a -> a.schoolIds), (App)LootRarity.mapCodec(LevelData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.validTypes)).apply((Applicative)inst, (def, singleSchool, schoolsArray, values, types) -> {
        Optional<List<ResourceLocation>> schoolIds = schoolsArray.isPresent() ? schoolsArray : singleSchool.map(List::of);
        return new SpellLevelAffix((AffixDefinition)def, schoolIds, (Map<LootRarity, LevelData>)values, (Set<LootCategory>)types);
    }));
    protected final Optional<List<ResourceLocation>> schoolIds;
    protected final Optional<Set<SchoolType>> schools;
    protected final Map<LootRarity, LevelData> values;
    protected final Set<LootCategory> validTypes;

    public SpellLevelAffix(AffixDefinition definition, Optional<List<ResourceLocation>> schoolIds, Map<LootRarity, LevelData> values, Set<LootCategory> types) {
        super(definition);
        this.schoolIds = schoolIds;
        this.schools = schoolIds.map(ids -> {
            HashSet<SchoolType> schoolSet = new HashSet<SchoolType>();
            for (ResourceLocation id : ids) {
                SchoolType school = (SchoolType)SchoolRegistry.REGISTRY.get(id);
                if (school != null) {
                    schoolSet.add(school);
                    continue;
                }
                Apotheosis.LOGGER.warn("Unknown school ID {} provided for SpellLevelAffix, ignoring.", (Object)id);
            }
            return schoolSet;
        });
        this.values = values;
        this.validTypes = types;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        LevelData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        int bonus = data.level().getInt(inst.level());
        Component schoolComponent = this.getSchoolComponent();
        String key = bonus == 1 ? "affix.irons_apothic.spell_level.desc.singular" : "affix.irons_apothic.spell_level.desc";
        return Component.translatable((String)key, (Object[])new Object[]{schoolComponent, bonus});
    }

    private Component getSchoolComponent() {
        if (this.schools.isEmpty()) {
            return Component.translatable((String)"affix.irons_apothic.school.generic");
        }
        Set<SchoolType> schoolSet = this.schools.get();
        if (schoolSet.isEmpty()) {
            return Component.translatable((String)"affix.irons_apothic.school.none");
        }
        SchoolType[] arr = schoolSet.toArray(new SchoolType[0]);
        if (arr.length == 1) {
            return SpellLevelAffix.formatSchool(arr[0]);
        }
        if (arr.length == 2) {
            return Component.empty().append(SpellLevelAffix.formatSchool(arr[0])).append((Component)Component.literal((String)" and ")).append(SpellLevelAffix.formatSchool(arr[1]));
        }
        if (arr.length == 3) {
            return Component.empty().append(SpellLevelAffix.formatSchool(arr[0])).append((Component)Component.literal((String)", ")).append(SpellLevelAffix.formatSchool(arr[1])).append((Component)Component.literal((String)", and ")).append(SpellLevelAffix.formatSchool(arr[2]));
        }
        return Component.empty().append(SpellLevelAffix.formatSchool(arr[0])).append((Component)Component.literal((String)", ")).append(SpellLevelAffix.formatSchool(arr[1])).append((Component)Component.literal((String)", ")).append(SpellLevelAffix.formatSchool(arr[2])).append((Component)Component.literal((String)", and ")).append(SpellLevelAffix.formatSchool(arr[3]));
    }

    private static Component formatSchool(SchoolType school) {
        String key = "school." + school.getId().getNamespace() + "." + school.getId().getPath();
        return Component.translatable((String)key).withStyle(school.getDisplayName().getStyle());
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        LevelData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        int currentBonus = data.level().getInt(inst.level());
        int minBonus = data.level().getInt(0.0f);
        int maxBonus = data.level().getInt(1.0f);
        Component schoolComponent = this.getSchoolComponent();
        String key = currentBonus == 1 ? "affix.irons_apothic.spell_level.desc.singular" : "affix.irons_apothic.spell_level.desc";
        MutableComponent comp = Component.translatable((String)key, (Object[])new Object[]{schoolComponent, currentBonus});
        if (minBonus != maxBonus) {
            MutableComponent minComp = Component.literal((String)String.valueOf(minBonus));
            MutableComponent maxComp = Component.literal((String)String.valueOf(maxBonus));
            comp.append((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    public Optional<Set<SchoolType>> getSchools() {
        return this.schools;
    }

    public int getBonusLevel(LootRarity rarity, float level) {
        LevelData data = this.values.get(rarity);
        return data != null ? data.level().getInt(level) : 0;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone() || !this.values.containsKey(rarity)) {
            return false;
        }
        if (!this.validTypes.isEmpty() && !this.validTypes.contains(cat)) {
            return false;
        }
        return SpellLevelAffix.matchesSchools(stack, this.schools);
    }

    public record LevelData(StepFunction level) {
        private static final Codec<LevelData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.optionalFieldOf("level", (Object)StepFunction.constant((float)1.0f)).forGetter(LevelData::level)).apply((Applicative)inst, LevelData::new));
    }
}

