/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.block.base;

import com.unrealdinnerbone.jamd.WorldType;
import com.unrealdinnerbone.jamd.util.TelerportUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class PortalBlock
extends Block
implements EntityBlock {
    private static final ResourceKey<Level> OVERWORLD = Level.OVERWORLD;
    private final WorldType type;

    public PortalBlock(WorldType type) {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.0f).sound(SoundType.STONE).mapColor(MapColor.COLOR_BLUE));
        this.type = type;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.type.getBlockEntity().get()).create(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hand) {
        if (!level.isClientSide()) {
            if (level.dimension().equals(this.type.getKey().level())) {
                TelerportUtils.teleport(player, OVERWORLD, pos, this.type);
            } else if (level.dimension().equals(OVERWORLD)) {
                TelerportUtils.teleport(player, this.type.getKey().level(), pos, this.type);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"You can't teleport from this dimension"), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

