/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.jumbo_furnace;

import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class OutputItemHandler
extends ItemStackHandler {
    public static final String EXPERIENCE = "xp";
    public final JumboFurnaceCoreBlockEntity te;
    public boolean forcingInserts = false;
    public float storedExperience = 0.0f;

    public OutputItemHandler(JumboFurnaceCoreBlockEntity te) {
        super(9);
        this.te = te;
    }

    public void addExperience(float experience) {
        this.storedExperience += experience;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.forcingInserts;
    }

    public ItemStack insertCraftResult(ItemStack stack, boolean simulate) {
        this.forcingInserts = true;
        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)this, (ItemStack)stack, (boolean)simulate);
        this.forcingInserts = false;
        return result;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.te.setChanged();
        this.te.markOutputInventoryChanged();
    }

    public float getAndConsumeExperience() {
        float amount = this.storedExperience;
        this.storedExperience = 0.0f;
        return amount;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag result = super.serializeNBT(registries);
        result.putFloat(EXPERIENCE, this.storedExperience);
        return result;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        super.deserializeNBT(registries, nbt);
        this.storedExperience = nbt.getFloat(EXPERIENCE);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack backstockStack;
        ItemStack result = super.extractItem(slot, amount, simulate);
        if (!(simulate || result.isEmpty() || !this.getStackInSlot(slot).isEmpty() || this.te.backstock.isEmpty() || (backstockStack = this.te.backstock.removeFirst()).isEmpty())) {
            this.setStackInSlot(slot, backstockStack);
        }
        return result;
    }
}

