/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.jei;

import com.direwolf20.justdirethings.client.jei.AbilityRecipeCategory;
import com.direwolf20.justdirethings.client.jei.FluidDropRecipeCategory;
import com.direwolf20.justdirethings.client.jei.GooSpreadRecipeCategory;
import com.direwolf20.justdirethings.client.jei.GooSpreadRecipeTagCategory;
import com.direwolf20.justdirethings.client.jei.OreToResourceCategory;
import com.direwolf20.justdirethings.client.jei.OreToResourceRecipe;
import com.direwolf20.justdirethings.client.jei.PaxelRecipeCategory;
import com.direwolf20.justdirethings.client.jei.ghostfilters.GhostFilterBasic;
import com.direwolf20.justdirethings.client.screens.basescreens.BaseScreen;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import com.direwolf20.justdirethings.datagen.recipes.AbilityRecipe;
import com.direwolf20.justdirethings.datagen.recipes.PaxelRecipe;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        Object recipe;
        BaseMachineBlock baseMachineBlock;
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList hiddenRecipes = new ArrayList();
        for (DeferredHolder sidedBlock : Registration.SIDEDBLOCKS.getEntries()) {
            Object object = sidedBlock.get();
            if (!(object instanceof BaseMachineBlock)) continue;
            baseMachineBlock = (BaseMachineBlock)((Object)object);
            recipe = recipeManager.byKey(ResourceLocation.parse((String)(String.valueOf(sidedBlock.getId()) + "_nbtclear")));
            ((Optional)recipe).ifPresent(recipeHolder -> hiddenRecipes.add(recipeHolder));
        }
        for (DeferredHolder sidedBlock : Registration.BLOCKS.getEntries()) {
            recipe = sidedBlock.get();
            if (!(recipe instanceof BaseMachineBlock)) continue;
            baseMachineBlock = (BaseMachineBlock)((Object)recipe);
            recipe = recipeManager.byKey(ResourceLocation.parse((String)(String.valueOf(sidedBlock.getId()) + "_nbtclear")));
            ((Optional)recipe).ifPresent(recipeHolder -> hiddenRecipes.add(recipeHolder));
        }
        recipeRegistry.hideRecipes(RecipeTypes.CRAFTING, hiddenRecipes);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new GooSpreadRecipeCategory(guiHelper), new GooSpreadRecipeTagCategory(guiHelper), new FluidDropRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new OreToResourceCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List goospreadrecipes = recipeManager.getAllRecipesFor(Registration.GOO_SPREAD_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(GooSpreadRecipeCategory.TYPE, goospreadrecipes);
        List goospreadtagrecipes = recipeManager.getAllRecipesFor(Registration.GOO_SPREAD_RECIPE_TYPE_TAG.get()).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(GooSpreadRecipeTagCategory.TYPE, goospreadtagrecipes);
        List fluidDropRecipes = recipeManager.getAllRecipesFor(Registration.FLUID_DROP_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(FluidDropRecipeCategory.TYPE, fluidDropRecipes);
        registration.addRecipes(new RecipeType(OreToResourceCategory.UID, OreToResourceRecipe.class), List.of(new OreToResourceRecipe((Block)Registration.RawFerricoreOre.get(), new ItemStack(Registration.RawFerricore)), new OreToResourceRecipe((Block)Registration.RawBlazegoldOre.get(), new ItemStack(Registration.RawBlazegold)), new OreToResourceRecipe((Block)Registration.RawCelestigemOre.get(), new ItemStack(Registration.Celestigem)), new OreToResourceRecipe((Block)Registration.RawEclipseAlloyOre.get(), new ItemStack(Registration.RawEclipseAlloy)), new OreToResourceRecipe((Block)Registration.RawCoal_T1.get(), new ItemStack(Registration.Coal_T1)), new OreToResourceRecipe((Block)Registration.RawCoal_T2.get(), new ItemStack(Registration.Coal_T2)), new OreToResourceRecipe((Block)Registration.RawCoal_T3.get(), new ItemStack(Registration.Coal_T3)), new OreToResourceRecipe((Block)Registration.RawCoal_T4.get(), new ItemStack(Registration.Coal_T4))));
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableSmithingRecipeCategory smithingCategory = registration.getSmithingCategory();
        smithingCategory.addExtension(AbilityRecipe.class, (ISmithingCategoryExtension)new AbilityRecipeCategory());
        smithingCategory.addExtension(PaxelRecipe.class, (ISmithingCategoryExtension)new PaxelRecipeCategory());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier1.get()), new RecipeType[]{GooSpreadRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier2.get()), new RecipeType[]{GooSpreadRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier3.get()), new RecipeType[]{GooSpreadRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier4.get()), new RecipeType[]{GooSpreadRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier1.get()), new RecipeType[]{GooSpreadRecipeTagCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier2.get()), new RecipeType[]{GooSpreadRecipeTagCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier3.get()), new RecipeType[]{GooSpreadRecipeTagCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GooBlock_Tier4.get()), new RecipeType[]{GooSpreadRecipeTagCategory.TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(BaseScreen.class, (IGhostIngredientHandler)new GhostFilterBasic());
    }
}

