/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.basescreens.SensorScreenInterface;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.BlockStateScrollList;
import com.direwolf20.justdirethings.client.screens.widgets.NumberButton;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.blockentities.SensorT1BE;
import com.direwolf20.justdirethings.common.blockentities.SensorT2BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.containers.SensorT2Container;
import com.direwolf20.justdirethings.common.containers.slots.FilterBasicSlot;
import com.direwolf20.justdirethings.common.network.data.BlockStateFilterPayload;
import com.direwolf20.justdirethings.common.network.data.SensorPayload;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;

public class SensorT2Screen
extends BaseMachineScreen<SensorT2Container>
implements SensorScreenInterface {
    public int senseTarget;
    public boolean strongSignal;
    public boolean showBlockStates;
    public int blockStateSlot = -1;
    private BlockStateScrollList scrollPanel;
    public ItemStack stateItemStack = ItemStack.EMPTY;
    public Map<Integer, Map<Property<?>, Comparable<?>>> blockStateProperties = new HashMap();
    public Map<Integer, ItemStack> itemStackCache = new HashMap<Integer, ItemStack>();
    public int senseAmount;
    public int equality;
    public SensorT2BE sensorT2BE;

    public SensorT2Screen(SensorT2Container container, Inventory inv, Component name) {
        super(container, inv, name);
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof SensorT2BE) {
            SensorT2BE sensor;
            this.sensorT2BE = sensor = (SensorT2BE)baseMachineBE;
            this.senseTarget = sensor.sense_target.ordinal();
            this.strongSignal = sensor.strongSignal;
            this.blockStateProperties = sensor.blockStateProperties;
            this.senseAmount = sensor.senseAmount;
            this.equality = sensor.equality;
            this.populateItemStackCache();
        }
    }

    @Override
    public void addFilterButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.ALLOWLISTBUTTON(this.getGuiLeft() + 8, this.topSectionTop + 62, this.filterData.allowlist, b -> {
            this.filterData.allowlist = !this.filterData.allowlist;
            this.saveSettings();
        }));
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SENSORTARGETBUTTON(this.getGuiLeft() + 26, this.topSectionTop + 62, this.senseTarget, b -> {
            this.senseTarget = ((ToggleButton)b).getTexturePosition();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.STRONGWEAKREDSTONEBUTTON(this.getGuiLeft() + 44, this.topSectionTop + 62, this.strongSignal ? 1 : 0, b -> {
            this.strongSignal = ((ToggleButton)b).getTexturePosition() == 1;
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)new NumberButton(this.getGuiLeft() + 122, this.topSectionTop + 64, 24, 12, this.senseAmount, 0, 9999, (Component)Component.translatable((String)"justdirethings.screen.senseamount"), b -> {
            this.senseAmount = ((NumberButton)b).getValue();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.EQUALSBUTTON(this.getGuiLeft() + 104, this.topSectionTop + 62, this.equality, b -> {
            this.equality = ((ToggleButton)b).getTexturePosition();
            this.saveSettings();
        }));
        this.scrollPanel = new BlockStateScrollList(this, this.topSectionLeft - 95, 90, this.topSectionTop + 5, this.topSectionTop + this.topSectionHeight - 10);
    }

    @Override
    public void setTopSection() {
        this.extraWidth = 60;
        this.extraHeight = 0;
    }

    @Override
    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (this.showBlockStates && MiscTools.inBounds(this.topSectionLeft - 101, this.topSectionTop, 100, this.topSectionHeight, mouseX, mouseY)) {
            return false;
        }
        return super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new SensorPayload(this.senseTarget, this.strongSignal, this.senseAmount, this.equality), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Comparable<?> getValue(Property<?> property) {
        if (!this.blockStateProperties.containsKey(this.blockStateSlot)) {
            return null;
        }
        Map<Property<?>, Comparable<?>> props = this.blockStateProperties.get(this.blockStateSlot);
        if (!props.containsKey(property)) {
            return null;
        }
        return props.get(property);
    }

    @Override
    public void setPropertyValue(Property<?> property, Comparable<?> comparable, boolean isAny) {
        Map props = this.blockStateProperties.getOrDefault(this.blockStateSlot, new HashMap());
        if (isAny) {
            props.remove(property);
        } else {
            props.put(property, comparable);
        }
        this.blockStateProperties.put(this.blockStateSlot, props);
        this.saveBlockStateData(this.blockStateSlot);
    }

    public void clearStateProperties(int slot) {
        this.blockStateProperties.put(slot, new HashMap());
    }

    public void populateItemStackCache() {
        for (int i = 0; i < this.container.FILTER_SLOTS; ++i) {
            ItemStack stack = this.container.filterHandler.getStackInSlot(i);
            this.itemStackCache.put(i, stack);
        }
    }

    public void validateItemStackCache() {
        for (int i = 0; i < this.container.FILTER_SLOTS; ++i) {
            ItemStack cachedStack;
            ItemStack stack = this.container.filterHandler.getStackInSlot(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(cachedStack = this.itemStackCache.get(i)))) continue;
            this.clearStateProperties(i);
            this.saveBlockStateData(i);
            this.itemStackCache.put(i, stack);
        }
    }

    public void saveBlockStateData(int slot) {
        if (!this.blockStateProperties.containsKey(slot)) {
            return;
        }
        Map<Property<?>, Comparable<?>> props = this.blockStateProperties.get(slot);
        CompoundTag tag = new CompoundTag();
        ListTag listTag = SensorT1BE.saveBlockStateProperty(props);
        tag.put("tagList", (Tag)listTag);
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockStateFilterPayload(slot, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.validateItemStackCache();
        if (this.showBlockStates) {
            guiGraphics.blitSprite(this.SOCIALBACKGROUND, this.topSectionLeft - 100, this.topSectionTop, 100, this.topSectionHeight);
            if (this.blockStateSlot != -1 && !this.container.filterHandler.getStackInSlot(this.blockStateSlot).equals(this.scrollPanel.getStateStack())) {
                this.refreshStateWindow();
            }
        }
    }

    public void refreshStateWindow() {
        if (!this.showBlockStates || this.blockStateSlot == -1) {
            return;
        }
        this.stateItemStack = this.container.filterHandler.getStackInSlot(this.blockStateSlot);
        this.scrollPanel.setStateStack(this.stateItemStack);
        this.scrollPanel.refreshList();
    }

    @Override
    public void powerBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof PoweredMachineBE) {
            PoweredMachineBE poweredMachineBE = (PoweredMachineBE)((Object)baseMachineBE);
            if (MiscTools.inBounds(this.topSectionLeft + 5, this.topSectionTop + 5, 18, 72, pX, pY)) {
                if (SensorT2Screen.hasShiftDown()) {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.formatted(this.container.getEnergy()), MagicHelpers.formatted(poweredMachineBE.getMaxEnergy())}), Component.translatable((String)"justdirethings.screen.energycost", (Object[])new Object[]{MagicHelpers.withSuffix(this.sensorT2BE.getEnergyCost())}))), pX, pY);
                } else {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.withSuffix(this.container.getEnergy()), MagicHelpers.withSuffix(poweredMachineBE.getMaxEnergy())}), Component.translatable((String)"justdirethings.screen.energycost", (Object[])new Object[]{MagicHelpers.withSuffix(this.sensorT2BE.getEnergyCost())}))), pX, pY);
                }
            }
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (this.hoveredSlot != null && this.hoveredSlot instanceof FilterBasicSlot) {
            if (((SensorT2Container)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                ItemStack itemstack = this.hoveredSlot.getItem();
                components.add(Component.translatable((String)"justdirethings.screen.rightclicksettings").withStyle(ChatFormatting.RED));
                components.addAll(this.getTooltipFromContainerItem(itemstack));
                pGuiGraphics.renderTooltip(this.font, components, itemstack.getTooltipImage(), itemstack, pX, pY);
            } else {
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                components.add(Component.translatable((String)"justdirethings.screen.rightclicksettings").withStyle(ChatFormatting.RED));
                pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(components), pX, pY);
            }
        } else {
            super.renderTooltip(pGuiGraphics, pX, pY);
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int btn) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)((Object)baseMachineBE);
            if (this.hoveredSlot != null && this.hoveredSlot instanceof FilterBasicSlot && btn == 1) {
                if (this.showBlockStates) {
                    this.blockStateSlot = -1;
                    this.stateItemStack = ItemStack.EMPTY;
                    this.scrollPanel.setStateStack(ItemStack.EMPTY);
                    this.removeWidget((GuiEventListener)this.scrollPanel);
                } else {
                    this.blockStateSlot = this.hoveredSlot.getSlotIndex();
                    this.stateItemStack = this.hoveredSlot.getItem();
                    this.scrollPanel.setStateStack(this.stateItemStack);
                    this.addRenderableWidget((GuiEventListener)this.scrollPanel);
                }
                this.showBlockStates = !this.showBlockStates;
                this.scrollPanel.refreshList();
                return true;
            }
        }
        return super.mouseClicked(x, y, btn);
    }
}

