/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.standardbuttons;

import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ValueButtonsDouble {
    private static final ResourceLocation add = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/add.png");
    private static final ResourceLocation subtract = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/remove.png");
    private static final int STANDARD_WIDTH = 12;
    private static final int STANDARD_HEIGHT = 12;
    private final Font font;
    private double value;
    private final double minValue;
    private final double maxValue;
    private final StringWidget valueDisplay;
    private final StringWidget labelDisplay;
    public List<AbstractWidget> widgetList = new ArrayList<AbstractWidget>();
    private BiConsumer<ValueButtonsDouble, Double> onPress;

    public ValueButtonsDouble(int x, int y, double startingValue, double minValue, double maxValue, Font font, BiConsumer<ValueButtonsDouble, Double> onPress) {
        this(x, y, startingValue, minValue, maxValue, (Component)Component.empty(), font, onPress);
    }

    public ValueButtonsDouble(int x, int y, double startingValue, double minValue, double maxValue, Component label, Font font, BiConsumer<ValueButtonsDouble, Double> onPress) {
        this.value = startingValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.font = font;
        this.onPress = onPress;
        Objects.requireNonNull(font);
        this.valueDisplay = new StringWidget(x + 11, y + 2, 20, 9, (Component)Component.literal((String)String.valueOf(startingValue)), font);
        this.widgetList.add((AbstractWidget)this.valueDisplay);
        Objects.requireNonNull(font);
        this.labelDisplay = new StringWidget(x, y - 8, 40, 9, label, font);
        this.widgetList.add((AbstractWidget)this.labelDisplay);
        this.widgetList.add((AbstractWidget)new GrayscaleButton(x, y, 12, 12, subtract, button -> {
            this.decrementValue();
            if (onPress != null) {
                onPress.accept(this, this.value);
            }
        }));
        this.widgetList.add((AbstractWidget)new GrayscaleButton(x + 30, y, 12, 12, add, button -> {
            this.incrementValue();
            if (onPress != null) {
                onPress.accept(this, this.value);
            }
        }));
    }

    private void incrementValue() {
        if (this.value < this.maxValue) {
            this.value += 0.5;
            this.updateDisplay();
        }
    }

    private void decrementValue() {
        if (this.value > this.minValue) {
            this.value -= 0.5;
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        this.valueDisplay.setMessage((Component)Component.literal((String)String.valueOf(this.value)));
    }

    public double getValue() {
        return this.value;
    }
}

