/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blocks.gooblocks;

import com.direwolf20.justdirethings.common.blockentities.basebe.GooBlockBE_Base;
import com.direwolf20.justdirethings.datagen.JustDireItemTags;
import com.direwolf20.justdirethings.setup.Registration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GooBlock_Base
extends Block
implements EntityBlock {
    public static final BooleanProperty ALIVE = BooleanProperty.create((String)"alive");

    public GooBlock_Base() {
        super(BlockBehaviour.Properties.of().sound(SoundType.FUNGUS).strength(2.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ALIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ALIVE});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!((Boolean)state.getValue((Property)ALIVE)).booleanValue() && this.validRevivalItem(itemStack)) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ALIVE, (Comparable)Boolean.valueOf(true)), 3);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, pos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 0.5f);
                }
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    protected boolean validRevivalItem(ItemStack itemStack) {
        return itemStack.is(JustDireItemTags.GOO_REVIVE_TIER_1);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof GooBlockBE_Base) {
                    GooBlockBE_Base tile = (GooBlockBE_Base)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof GooBlockBE_Base) {
                GooBlockBE_Base tile = (GooBlockBE_Base)t;
                tile.tickServer();
            }
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GooBlockBE_Base((BlockEntityType)Registration.GooBlockBE_Tier1.get(), pos, state);
    }
}

