/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.mixin;

import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CollisionGetter.class})
public interface CollisionMixin {
    @Inject(method={"collidesWithSuffocatingBlock(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void collidesWithSuffocatingBlock(Entity entity, AABB box, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof Player && this.shouldPassThroughWalls((Player)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getBlockCollisions"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockCollisions(Entity entity, AABB collisionBox, CallbackInfoReturnable<Iterable<VoxelShape>> cir) {
        Player player;
        if (entity instanceof Player && this.shouldPassThroughWalls(player = (Player)entity)) {
            Iterable<VoxelShape> originalBlockCollisions = this.getOriginalBlockCollisions(entity, collisionBox);
            List filteredBlockCollisions = StreamSupport.stream(originalBlockCollisions.spliterator(), false).filter(shape -> this.isVerticalCollision((VoxelShape)shape, collisionBox, player)).collect(Collectors.toList());
            cir.setReturnValue(filteredBlockCollisions);
        }
    }

    private Iterable<VoxelShape> getOriginalBlockCollisions(Entity entity, AABB collisionBox) {
        return () -> new BlockCollisions((CollisionGetter)this, entity, collisionBox, false, (p_286215_, p_286216_) -> p_286216_);
    }

    default public boolean isVerticalCollision(VoxelShape shape, AABB collisionBox, Player player) {
        double minY;
        BlockPos blockPos;
        Level level = player.level();
        BlockState blockState = level.getBlockState(blockPos = new BlockPos((int)shape.min(Direction.Axis.X), (int)shape.min(Direction.Axis.Y), (int)shape.min(Direction.Axis.Z)));
        if (blockState.getDestroySpeed((BlockGetter)level, blockPos) < 0.0f || blockState.is(JustDireBlockTags.PHASEDENY)) {
            return true;
        }
        double maxY = shape.max(Direction.Axis.Y);
        boolean isDifferenceLessThanPointTwo = Math.abs(maxY - (minY = collisionBox.minY)) < 0.75;
        return isDifferenceLessThanPointTwo;
    }

    default public boolean shouldPassThroughWalls(Player player) {
        return player.getAttributeValue(Registration.PHASE) > 0.0;
    }
}

