/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.util.TickDuration;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.datamaps.chemical.ChemicalSolidTag;
import mekanism.api.datamaps.chemical.attribute.ChemicalFuel;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.datamaps.chemical.attribute.CooledCoolant;
import mekanism.api.datamaps.chemical.attribute.HeatedCoolant;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

@ReturnsSelf
public class KubeChemicalBuilder
extends BuilderBase<Chemical> {
    protected ChemicalBuilder chemicalBuilder;
    public transient ChemicalFuel fuel;
    public transient HeatedCoolant heatedCoolant;
    public transient CooledCoolant cooledCoolant;
    public transient ChemicalRadioactivity radiation;
    public transient ChemicalSolidTag ore;

    public KubeChemicalBuilder(ResourceLocation id) {
        super(id);
    }

    private ChemicalBuilder chemicalBuilder() {
        if (this.chemicalBuilder == null) {
            this.chemicalBuilder = ChemicalBuilder.builder();
        }
        return this.chemicalBuilder;
    }

    public KubeChemicalBuilder fuel(TickDuration burnTicks, long energyDensity) {
        if (burnTicks.ticks() > 0L && energyDensity > 0L) {
            this.fuel = new ChemicalFuel((int)burnTicks.ticks(), energyDensity);
        }
        return this;
    }

    public KubeChemicalBuilder heatedCoolant(Holder<Chemical> chemical, double thermalEnthalpy, double conductivity, double temperature) {
        if (thermalEnthalpy > 0.0 && conductivity > 0.0) {
            this.heatedCoolant = new HeatedCoolant(chemical, thermalEnthalpy, conductivity, temperature);
        }
        return this;
    }

    public KubeChemicalBuilder heatedCoolant(Holder<Chemical> chemical, double thermalEnthalpy, double conductivity) {
        return this.heatedCoolant(chemical, thermalEnthalpy, conductivity, 100000.0);
    }

    public KubeChemicalBuilder cooledCoolant(Holder<Chemical> chemical, double thermalEnthalpy, double conductivity) {
        if (thermalEnthalpy > 0.0 && conductivity > 0.0) {
            this.cooledCoolant = new CooledCoolant(chemical, thermalEnthalpy, conductivity);
        }
        return this;
    }

    public KubeChemicalBuilder radiation(double radioactivity) {
        if (radioactivity > 0.0) {
            this.radiation = new ChemicalRadioactivity(radioactivity);
        }
        return this;
    }

    public KubeChemicalBuilder tint(KubeColor tint) {
        this.chemicalBuilder().tint(tint.kjs$getRGB());
        return this;
    }

    public KubeChemicalBuilder ore(TagKey<Item> oreTag) {
        this.ore = new ChemicalSolidTag(oreTag);
        return this;
    }

    public KubeChemicalBuilder gaseous() {
        this.tag(new ResourceLocation[]{MekanismAPITags.Chemicals.GASEOUS.location()});
        return this;
    }

    public Chemical createObject() {
        return new Chemical(this.chemicalBuilder());
    }

    public static class Pigment
    extends KubeChemicalBuilder {
        public Pigment(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.pigment();
        }
    }

    public static class InfuseType
    extends KubeChemicalBuilder {
        public InfuseType(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.infuseType();
        }
    }

    public static class DirtySlurry
    extends KubeChemicalBuilder {
        public DirtySlurry(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.dirtySlurry();
        }
    }

    public static class CleanSlurry
    extends KubeChemicalBuilder {
        public CleanSlurry(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.cleanSlurry();
        }
    }

    public static class Liquid
    extends KubeChemicalBuilder {
        public Liquid(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.builder();
        }
    }

    @ReturnsSelf
    public static class Default
    extends KubeChemicalBuilder {
        public Default(ResourceLocation id) {
            super(id);
        }

        public Default texture(ResourceLocation texture) {
            this.chemicalBuilder = ChemicalBuilder.builder((ResourceLocation)texture);
            return this;
        }
    }
}

