/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.AABBWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.DirectionWrapper;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ModelGenerator {
    private static final ResourceLocation CUBE = ResourceLocation.withDefaultNamespace((String)"block/cube");
    private ResourceLocation parent = CUBE;
    private final Map<String, String> textures = new HashMap<String, String>(1);
    private final List<Element> elements = new ArrayList<Element>();
    private final List<Override> overrides = new ArrayList<Override>();
    private Consumer<JsonObject> customJson = null;

    public JsonObject toJson() {
        JsonArray a;
        JsonObject json = new JsonObject();
        if (this.parent != null) {
            json.addProperty("parent", this.parent.toString());
        }
        if (!this.textures.isEmpty()) {
            JsonObject o = new JsonObject();
            for (Map.Entry entry : this.textures.entrySet()) {
                o.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            json.add("textures", (JsonElement)o);
        }
        if (!this.elements.isEmpty()) {
            a = new JsonArray();
            for (Element element : this.elements) {
                a.add((JsonElement)element.toJson());
            }
            json.add("elements", (JsonElement)a);
        }
        if (!this.overrides.isEmpty()) {
            a = new JsonArray();
            for (Override override : this.overrides) {
                a.add((JsonElement)override.toJson());
            }
            json.add("overrides", (JsonElement)a);
        }
        if (this.customJson != null) {
            this.customJson.accept(json);
        }
        return json;
    }

    public void parent(@Nullable ResourceLocation s) {
        this.parent = s;
    }

    @HideFromJS
    public void texture(String name, String texture) {
        this.textures.put(name, texture);
    }

    public void texture(String[] name, String texture) {
        for (String n : name) {
            this.textures.put(n, texture);
        }
    }

    public void textures(Map<String, String> map) {
        this.textures.putAll(map);
    }

    public void element(Consumer<Element> consumer) {
        Element e = new Element();
        consumer.accept(e);
        this.elements.add(e);
    }

    public void override(ResourceLocation model, Consumer<Override> override) {
        Override o = new Override(model);
        override.accept(o);
        this.overrides.add(o);
    }

    public void custom(Consumer<JsonObject> json) {
        this.customJson = json;
    }

    public static class Element {
        private AABB size = AABBWrapper.CUBE;
        private final Face[] faces = new Face[6];

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            JsonArray f = new JsonArray();
            f.add((Number)(this.size.minX * 16.0));
            f.add((Number)(this.size.minY * 16.0));
            f.add((Number)(this.size.minZ * 16.0));
            json.add("from", (JsonElement)f);
            JsonArray t = new JsonArray();
            t.add((Number)(this.size.maxX * 16.0));
            t.add((Number)(this.size.maxY * 16.0));
            t.add((Number)(this.size.maxZ * 16.0));
            json.add("to", (JsonElement)t);
            JsonObject fc = new JsonObject();
            for (Face face : this.faces) {
                if (face == null) continue;
                fc.add(face.side.getSerializedName(), (JsonElement)face.toJson());
            }
            json.add("faces", (JsonElement)fc);
            return json;
        }

        public Element size(AABB b) {
            this.size = b;
            return this;
        }

        public void allFaces(Consumer<Face> face) {
            this.faces(DirectionWrapper.VALUES, face);
        }

        public void faces(Direction[] sides, Consumer<Face> face) {
            for (Direction d : sides) {
                Face f = this.faces[d.ordinal()];
                if (f == null) {
                    this.faces[d.ordinal()] = f = new Face(d);
                }
                face.accept(f);
            }
        }
    }

    public static class Override {
        private final ResourceLocation model;
        private final List<OverridePredicate> predicates = new ArrayList<OverridePredicate>();

        public Override(ResourceLocation model) {
            this.model = model;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("model", this.model.toString());
            JsonObject p = new JsonObject();
            for (OverridePredicate predicate : this.predicates) {
                predicate.toJson(p);
            }
            json.add("predicate", (JsonElement)p);
            return json;
        }

        public void predicate(ResourceLocation property, float value) {
            this.predicates.add(new OverridePredicate(property, value));
        }
    }

    public record OverridePredicate(ResourceLocation property, float value) {
        public void toJson(JsonObject json) {
            json.addProperty(this.property.toString(), (Number)Float.valueOf(this.value));
        }
    }

    public static class Face {
        public final Direction side;
        private String texture = "kubejs:block/unknown";
        private Direction cullface = null;
        private double[] uv = null;
        private int tintindex = -1;

        public Face(Direction side) {
            this.side = side;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("texture", this.texture);
            if (this.cullface != null) {
                json.addProperty("cullface", this.cullface.getSerializedName());
            }
            if (this.uv != null) {
                JsonArray a = new JsonArray();
                a.add((Number)this.uv[0]);
                a.add((Number)this.uv[1]);
                a.add((Number)this.uv[2]);
                a.add((Number)this.uv[3]);
                json.add("uv", (JsonElement)a);
            }
            if (this.tintindex >= 0) {
                json.addProperty("tintindex", (Number)this.tintindex);
            }
            return json;
        }

        public Face tex(String t) {
            this.texture = t;
            return this;
        }

        public Face cull(Direction d) {
            this.cullface = d;
            return this;
        }

        public Face cull() {
            return this.cull(this.side);
        }

        public Face uv(double u0, double v0, double u1, double v1) {
            this.uv = new double[]{u0, v0, u1, v1};
            return this;
        }

        public Face tintindex(int i) {
            this.tintindex = i;
            return this;
        }
    }
}

