/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.handler;

import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.network.data.CopyPasteCardPayload;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketCopyPasteCard {
    public static final PacketCopyPasteCard INSTANCE = new PacketCopyPasteCard();

    public static PacketCopyPasteCard get() {
        return INSTANCE;
    }

    public void handle(CopyPasteCardPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu container = player.containerMenu;
            if (container == null) {
                return;
            }
            if (!(container instanceof LaserNodeContainer)) {
                return;
            }
            LaserNodeContainer laserNodeContainer = (LaserNodeContainer)container;
            if (player.containerMenu.getCarried().isEmpty()) {
                return;
            }
            ItemStack slotStack = container.getSlot(payload.slot()).getItem();
            ItemStack clonerStack = container.getCarried();
            if (payload.copy()) {
                DataComponentPatch dataComponentPatch = slotStack.getComponentsPatch();
                CardCloner.saveSettings(clonerStack, dataComponentPatch);
                CardCloner.setItemType(clonerStack, slotStack.getItem().toString());
                PacketCopyPasteCard.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT.getLocation().toString()))));
            } else if (slotStack.getItem().toString().equals(CardCloner.getItemType(clonerStack))) {
                ItemStack findStack;
                int amtNeeded;
                ItemStack returnStack;
                int amtReturn;
                CardItemHandler cardItemHandler = BaseCard.getInventory(slotStack);
                ItemStack filterNeeded = CardCloner.getFilter(clonerStack);
                ItemStack existingFilter = cardItemHandler.getStackInSlot(0);
                ItemStack overclockersNeeded = CardCloner.getOverclocker(clonerStack);
                ItemStack existingOverclockers = cardItemHandler.getStackInSlot(1);
                boolean filterSatisfied = false;
                boolean filterNeedsReturn = false;
                boolean overclockSatisfied = false;
                boolean overclockNeedsReturn = false;
                if (existingFilter.is(filterNeeded.getItem())) {
                    filterSatisfied = true;
                } else {
                    if (!existingFilter.isEmpty()) {
                        boolean bl = filterNeedsReturn = !PacketCopyPasteCard.returnItemToholder(laserNodeContainer, existingFilter, true);
                    }
                    if (!filterNeedsReturn) {
                        filterSatisfied = PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, filterNeeded, true);
                    }
                }
                if (existingOverclockers.getCount() == overclockersNeeded.getCount()) {
                    overclockSatisfied = true;
                } else if (existingOverclockers.getCount() > overclockersNeeded.getCount()) {
                    amtReturn = existingOverclockers.getCount() - overclockersNeeded.getCount();
                    returnStack = new ItemStack((ItemLike)existingOverclockers.getItem(), amtReturn);
                    overclockNeedsReturn = !PacketCopyPasteCard.returnItemToholder(laserNodeContainer, returnStack, true);
                    overclockSatisfied = true;
                } else {
                    amtNeeded = overclockersNeeded.getCount() - existingOverclockers.getCount();
                    findStack = new ItemStack((ItemLike)overclockersNeeded.getItem(), amtNeeded);
                    overclockSatisfied = PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, findStack, true);
                }
                if (filterSatisfied && !filterNeedsReturn && overclockSatisfied && !overclockNeedsReturn) {
                    if (!existingFilter.is(filterNeeded.getItem())) {
                        boolean success = PacketCopyPasteCard.returnItemToholder(laserNodeContainer, existingFilter, false);
                        if (!success) {
                            ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), existingFilter);
                            player.level().addFreshEntity((Entity)itemEntity);
                        }
                        PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, filterNeeded, false);
                    }
                    if (existingOverclockers.getCount() != overclockersNeeded.getCount()) {
                        if (existingOverclockers.getCount() > overclockersNeeded.getCount()) {
                            amtReturn = existingOverclockers.getCount() - overclockersNeeded.getCount();
                            returnStack = new ItemStack((ItemLike)existingOverclockers.getItem(), amtReturn);
                            boolean success = PacketCopyPasteCard.returnItemToholder(laserNodeContainer, returnStack, false);
                            if (!success) {
                                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), returnStack);
                                player.level().addFreshEntity((Entity)itemEntity);
                            }
                        } else {
                            amtNeeded = overclockersNeeded.getCount() - existingOverclockers.getCount();
                            findStack = new ItemStack((ItemLike)overclockersNeeded.getItem(), amtNeeded);
                            PacketCopyPasteCard.getItemFromHolder(laserNodeContainer, findStack, false);
                        }
                    }
                    ItemStack tempStack = slotStack.copy();
                    tempStack.getComponentsPatch().entrySet().forEach(k -> tempStack.remove((DataComponentType)k.getKey()));
                    DataComponentPatch dataComponentPatch = CardCloner.getSettings(clonerStack);
                    tempStack.applyComponents(dataComponentPatch);
                    container.getSlot(payload.slot()).set(tempStack);
                    PacketCopyPasteCard.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)SoundEvents.ENCHANTMENT_TABLE_USE.getLocation().toString()))));
                    ((LaserNodeContainer)container).tile.updateThisNode();
                } else {
                    PacketCopyPasteCard.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
                }
            } else {
                PacketCopyPasteCard.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
            }
        });
    }

    public static void playSound(ServerPlayer player, Holder<SoundEvent> soundEventHolder) {
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        ClientboundSoundPacket packet = new ClientboundSoundPacket(soundEventHolder, SoundSource.MASTER, x, y, z, 1.0f, 1.0f, 1L);
        player.connection.send((Packet)packet);
    }

    public static boolean returnItemToholder(LaserNodeContainer container, ItemStack itemStack, boolean simulate) {
        if (itemStack.isEmpty()) {
            return true;
        }
        int neededReturn = itemStack.getCount();
        HashMap<Integer, Integer> returnStackMap = new HashMap<Integer, Integer>();
        for (int returnSlot = 10; returnSlot < LaserNodeContainer.SLOTS; ++returnSlot) {
            ItemStack possibleReturnStack = container.getSlot(returnSlot).getItem();
            if (!possibleReturnStack.isEmpty() && (!possibleReturnStack.is(itemStack.getItem()) || possibleReturnStack.getCount() >= possibleReturnStack.getMaxStackSize())) continue;
            int roomAvailable = possibleReturnStack.getMaxStackSize() - possibleReturnStack.getCount();
            int amtFit = neededReturn - roomAvailable < 0 ? neededReturn : neededReturn - roomAvailable;
            returnStackMap.put(returnSlot, amtFit);
            if ((neededReturn -= amtFit) != 0) continue;
            if (!simulate) break;
            return true;
        }
        if (neededReturn > 0 || returnStackMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : returnStackMap.entrySet()) {
            ItemStack possibleReturnStack = container.getSlot((Integer)entry.getKey()).getItem();
            if (possibleReturnStack.isEmpty()) {
                container.getSlot((Integer)entry.getKey()).set(itemStack);
                possibleReturnStack = container.getSlot((Integer)entry.getKey()).getItem();
                possibleReturnStack.setCount(((Integer)entry.getValue()).intValue());
                container.getSlot((Integer)entry.getKey()).setByPlayer(possibleReturnStack);
                continue;
            }
            possibleReturnStack.grow(((Integer)entry.getValue()).intValue());
            container.getSlot((Integer)entry.getKey()).setByPlayer(possibleReturnStack);
        }
        return true;
    }

    public static boolean getItemFromHolder(LaserNodeContainer container, ItemStack itemStack, boolean simulate) {
        if (itemStack.isEmpty()) {
            return true;
        }
        int neededCount = itemStack.getCount();
        HashMap<Integer, Integer> findStackMap = new HashMap<Integer, Integer>();
        for (int getSlot = 10; getSlot < LaserNodeContainer.SLOTS; ++getSlot) {
            ItemStack possibleStack = container.getSlot(getSlot).getItem();
            if (!possibleStack.is(itemStack.getItem())) continue;
            int stackAvailable = possibleStack.getCount();
            int amtFound = neededCount - stackAvailable < 0 ? neededCount : stackAvailable;
            findStackMap.put(getSlot, amtFound);
            if ((neededCount -= amtFound) != 0) continue;
            if (!simulate) break;
            return true;
        }
        if (neededCount > 0 || findStackMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : findStackMap.entrySet()) {
            ItemStack possibleStack = container.getSlot((Integer)entry.getKey()).getItem();
            possibleStack.shrink(((Integer)entry.getValue()).intValue());
            container.getSlot((Integer)entry.getKey()).setByPlayer(possibleStack);
        }
        return true;
    }
}

