/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import team.lodestar.lodestone.attachment.WorldEventAttachment;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.registry.common.LodestoneAttachmentTypes;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class ListActiveWorldEventsCommand {
    private static final int whitespaceWidth = 20;
    private static final int ITEMS_PER_PAGE = 10;
    private static final int currentPage = 0;

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"all").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.getLevel();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level);
            report.buildInteractiveMessage(component -> source.sendSuccess(() -> component, true), 0);
            return 1;
        }))).then(Commands.literal((String)"type").then(Commands.argument((String)"worldEventType", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            WorldEventType worldEventType = WorldEventTypeArgument.getEventType(ctx, "worldEventType");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.getLevel();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level, worldEventType);
            report.buildInteractiveMessage(component -> source.sendSuccess(() -> component, true), 0);
            return 1;
        })))).then(Commands.literal((String)"page").then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int page = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.getLevel();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level);
            report.buildInteractiveMessage(component -> source.sendSuccess(() -> component, true), page);
            return 1;
        })));
    }

    protected static class ActiveWorldEventReport {
        private int instanceCount;
        private int frozenCount;
        private List<WorldEventInstance> activeWorldEvents;

        protected ActiveWorldEventReport(ServerLevel level) {
            WorldEventAttachment data = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            this.instanceCount = data.activeWorldEvents.size();
            this.frozenCount = (int)data.activeWorldEvents.stream().filter(WorldEventInstance::isFrozen).count();
            this.activeWorldEvents = data.activeWorldEvents;
        }

        protected ActiveWorldEventReport(ServerLevel level, WorldEventType worldEventType) {
            WorldEventAttachment data = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            this.instanceCount = (int)data.activeWorldEvents.stream().filter(worldEventInstance -> worldEventInstance.type.equals(worldEventType)).count();
            this.frozenCount = (int)data.activeWorldEvents.stream().filter(worldEventInstance -> worldEventInstance.type.equals(worldEventType) && worldEventInstance.isFrozen()).count();
            this.activeWorldEvents = data.activeWorldEvents;
        }

        private void buildInteractiveMessage(Consumer<Component> consumer, int page) {
            this.buildHeader(consumer);
            this.buildInteractiveIndexPage(consumer, page);
            this.buildInteractiveFooter(consumer, page);
        }

        private void buildInteractiveIndexPage(Consumer<Component> consumer, int page) {
            int startIndex = page * 10;
            int endIndex = Math.min(startIndex + 10, this.activeWorldEvents.size());
            for (int i = startIndex; i < endIndex; ++i) {
                WorldEventInstance event = this.activeWorldEvents.get(i);
                MutableComponent eventComponent = Component.literal((String)String.format("%02d. | %s | ", i + 1, event.type.id.toString())).withStyle(Style.EMPTY.withColor(i % 2 == 1 ? ChatFormatting.GRAY : ChatFormatting.WHITE).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)event.toString()))));
                MutableComponent detailsButton = Component.literal((String)"[>]").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent get " + event.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to see details"))));
                MutableComponent freezeButton = Component.literal((String)"[F]").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent freeze single " + event.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to freeze"))));
                MutableComponent unfreezeButton = Component.literal((String)"[U]").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent unfreeze single " + event.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to unfreeze"))));
                MutableComponent removeButton = Component.literal((String)"[X]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent remove single " + event.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to remove"))));
                MutableComponent space = Component.literal((String)"  ");
                consumer.accept((Component)eventComponent.append((Component)space).append((Component)detailsButton).append((Component)space).append((Component)(event.isFrozen() ? unfreezeButton : freezeButton)).append((Component)space).append((Component)removeButton));
            }
        }

        protected void buildInstanceDetailsPage(Consumer<Component> consumer, WorldEventInstance worldEventInstance) {
            MutableComponent worldEventDetailsHeader = Component.literal((String)"World Event Details:").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withBold(Boolean.valueOf(true)));
            MutableComponent worldEventUUID = Component.literal((String)"UUID: ").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)).append((Component)Component.literal((String)worldEventInstance.uuid.toString()).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, worldEventInstance.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy")))));
            MutableComponent worldEventType = Component.literal((String)"Type: ").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)).append((Component)Component.literal((String)worldEventInstance.type.id.toString()).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list type " + worldEventInstance.type.id.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to filter by type")))));
            MutableComponent frozenStatus = Component.literal((String)"Frozen: ").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)).append((Component)Component.literal((String)(worldEventInstance.isFrozen() ? "Yes" : "No")).withStyle(Style.EMPTY.withColor(worldEventInstance.isFrozen() ? ChatFormatting.DARK_AQUA : ChatFormatting.GREEN)));
            MutableComponent worldEventData = Component.literal((String)"Data:").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
            this.buildWhitespace(consumer);
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            consumer.accept((Component)worldEventDetailsHeader);
            consumer.accept((Component)worldEventUUID);
            consumer.accept((Component)worldEventType);
            consumer.accept((Component)frozenStatus);
            consumer.accept((Component)ActiveWorldEventReport.getDashedSpaceLine().withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)));
            consumer.accept((Component)worldEventData);
            this.buildDetailsBody(consumer, worldEventInstance.serializeNBT());
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            this.buildInteractiveFooter(consumer, worldEventInstance);
        }

        private void buildDetailsBody(Consumer<Component> consumer, CompoundTag tag) {
            tag.tags.forEach((key, value) -> {
                if (key.equals("uuid") || key.equals("type") || key.equals("discarded") || key.equals("frozen")) {
                    return;
                }
                MutableComponent keyComponent = Component.literal((String)(key + ": ")).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
                MutableComponent valueComponent = Component.literal((String)value.toString()).withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE));
                consumer.accept((Component)keyComponent.append((Component)valueComponent));
            });
        }

        private void buildInteractiveFooter(Consumer<Component> consumer, WorldEventInstance instance) {
            MutableComponent backButton = Component.literal((String)"[Back]").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page 0")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Back to World Event List"))));
            MutableComponent freezeButton = Component.literal((String)"[Freeze]").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_BLUE).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent freeze single " + instance.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Freeze this World Event"))));
            MutableComponent unfreezeButton = Component.literal((String)"[Unfreeze]").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent unfreeze single " + instance.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Unfreeze this World Event"))));
            MutableComponent removeButton = Component.literal((String)"[Remove]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent remove single " + instance.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Remove this World Event"))));
            MutableComponent reloadButton = Component.literal((String)"[Reload]").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent get " + instance.uuid.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Reload this World Event"))));
            consumer.accept((Component)backButton.append("  ").append((Component)(instance.isFrozen() ? unfreezeButton : freezeButton)).append("  ").append((Component)removeButton).append("  ").append((Component)reloadButton));
        }

        private void buildHeader(Consumer<Component> consumer) {
            this.buildWhitespace(consumer);
            consumer.accept((Component)Component.translatable((String)"There are %s active World Events", (Object[])new Object[]{this.instanceCount}).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            consumer.accept((Component)Component.translatable((String)"%s events are frozen", (Object[])new Object[]{this.frozenCount}).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA)));
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
        }

        private void buildInteractiveFooter(Consumer<Component> consumer, int page) {
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            MutableComponent previousPage = Component.literal((String)"[<]").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page " + (page - 1))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Previous Page"))));
            MutableComponent nextPage = Component.literal((String)"[>]").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page " + (page + 1))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Next Page"))));
            MutableComponent removeAll = Component.literal((String)"[Remove All]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent remove all")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Remove all active World Events"))));
            MutableComponent freezeAll = Component.literal((String)"[Freeze All]").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_BLUE).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent freeze all")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Freeze all active World Events"))));
            MutableComponent unfreezeAll = Component.literal((String)"[Unfreeze All]").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent unfreeze all")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Unfreeze all active World Events"))));
            MutableComponent reload = Component.literal((String)"[Reload]").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page " + page)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Reload active World Events"))));
            MutableComponent pageNumber = Component.literal((String)String.valueOf(page)).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
            MutableComponent navigation = previousPage.append("  ").append((Component)pageNumber).append("  ").append((Component)nextPage);
            MutableComponent freezeUnfreeze = this.frozenCount == this.instanceCount ? unfreezeAll : freezeAll;
            consumer.accept((Component)navigation.append("  ").append((Component)freezeUnfreeze).append("  ").append((Component)removeAll).append("  ").append((Component)reload));
        }

        private void buildWhitespace(Consumer<Component> consumer) {
            for (int i = 0; i < 20; ++i) {
                consumer.accept((Component)Component.literal((String)" "));
            }
        }

        private static MutableComponent getDashedLine() {
            return Component.literal((String)"-".repeat(40));
        }

        private static MutableComponent getDashedSpaceLine() {
            return Component.literal((String)"- ".repeat(25));
        }
    }
}

