/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.systems.postprocess.PostProcessHandler;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderSystem;
import team.lodestar.lodestone.systems.rendering.renderpass.RenderPassHandler;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Inject(method={"resize"}, at={@At(value="HEAD")})
    public void lodestone$injectionResizeListener(int width, int height, CallbackInfo ci) {
        LodestoneRenderHandler.resize(width, height);
        PostProcessHandler.resize(width, height);
        RenderPassHandler.resize(width, height);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V")})
    private void lodestone$beforeRenderLevel(DeltaTracker deltaTracker, CallbackInfo ci, @Local Camera camera, @Local(ordinal=0) Matrix4f projMat, @Local(ordinal=1) Matrix4f viewMat) {
        RenderPassHandler.render(deltaTracker, camera, (GameRenderer)this, new Matrix4f((Matrix4fc)viewMat), new Matrix4f((Matrix4fc)projMat));
    }

    @ModifyArgs(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"))
    public void lodestone$extractViewBob(Args args) {
        LodestoneRenderSystem.setViewBobOffset(-((Float)args.get(0)).floatValue(), -((Float)args.get(1)).floatValue(), -((Float)args.get(2)).floatValue());
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    public void lodestone$clearViewBob(CallbackInfo ci) {
        if (!((Boolean)Minecraft.getInstance().options.bobView().get()).booleanValue()) {
            LodestoneRenderSystem.setViewBobOffset(0.0f, 0.0f, 0.0f);
        }
    }
}

