/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.geo.data;

import org.joml.Vector2f;
import org.joml.Vector2fc;
import team.lodestar.lodestone.systems.model.geo.data.GeoVertex;

public class GeoQuad {
    GeoVertex[] vertices;

    public GeoQuad(GeoVertex[] vertices) {
        this.vertices = vertices;
    }

    public static GeoQuad build(GeoVertex[] vertices, Vector2f uv, Vector2f uvSize, int rotation, Vector2f textureSize) {
        Vector2f uv0 = uv.div((Vector2fc)textureSize, new Vector2f());
        Vector2f uv1 = uv.add((Vector2fc)uvSize, new Vector2f()).div((Vector2fc)textureSize);
        Vector2f[] rotatedUVs = GeoQuad.rotateUVs(uv0, uv1, rotation);
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = vertices[i].copy();
            vertices[i].setTexCoords(rotatedUVs[i]);
        }
        return new GeoQuad(vertices);
    }

    private static Vector2f[] rotateUVs(Vector2f uv0, Vector2f uv1, int rotation) {
        Vector2f[] vector2fArray;
        Vector2f a = new Vector2f(uv1.x, uv0.y);
        Vector2f b = new Vector2f(uv0.x, uv1.y);
        switch (rotation) {
            case 0: {
                Vector2f[] vector2fArray2 = new Vector2f[4];
                vector2fArray2[0] = uv0;
                vector2fArray2[1] = a;
                vector2fArray2[2] = uv1;
                vector2fArray = vector2fArray2;
                vector2fArray2[3] = b;
                break;
            }
            case 90: {
                Vector2f[] vector2fArray3 = new Vector2f[4];
                vector2fArray3[0] = a;
                vector2fArray3[1] = uv1;
                vector2fArray3[2] = b;
                vector2fArray = vector2fArray3;
                vector2fArray3[3] = uv0;
                break;
            }
            case 180: {
                Vector2f[] vector2fArray4 = new Vector2f[4];
                vector2fArray4[0] = uv1;
                vector2fArray4[1] = b;
                vector2fArray4[2] = uv0;
                vector2fArray = vector2fArray4;
                vector2fArray4[3] = a;
                break;
            }
            case 270: {
                Vector2f[] vector2fArray5 = new Vector2f[4];
                vector2fArray5[0] = b;
                vector2fArray5[1] = uv0;
                vector2fArray5[2] = a;
                vector2fArray = vector2fArray5;
                vector2fArray5[3] = uv1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rotation: " + rotation);
            }
        }
        return vector2fArray;
    }
}

