/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.config.CommonConfiguration;
import com.lootintegrations.loot.INoMapContext;
import com.lootintegrations.loot.LootModifierManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class GlobalLootModifierIntegration {
    private final ResourceLocation location;
    public ResourceLocation lootTableId;
    public Map<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
    private int fillSize = 27;
    private static final Set<ResourceLocation> inbuiltTables = Set.of(LootintegrationsMod.resFor("chests/easy"), LootintegrationsMod.resFor("chests/medium"), LootintegrationsMod.resFor("chests/hard"), LootintegrationsMod.resFor("chests/nether"), LootintegrationsMod.resFor("chests/water"), LootintegrationsMod.resFor("chests/village"), LootintegrationsMod.resFor("chests/empty"));
    private static final String LOOT_TABLE_ID = "loot_table";
    private static final String INTEGRATED_LOOT_TABLES = "integrated_loot_tables";
    private static final String MAX_RESULT_ITEMCOUNT = "max_result_itemcount";

    private GlobalLootModifierIntegration(ResourceLocation location) {
        this.location = location;
    }

    public void doApply(List<ItemStack> generatedLoot, LootContext context, LootTable lootTable) {
        int weight;
        int i;
        Object extraItems = new ArrayList();
        try {
            LootContext generatingContext = new LootContext.Builder(context).withQueriedLootTableId(this.lootTableId).create(Optional.empty());
            if (generatingContext instanceof INoMapContext) {
                INoMapContext noMapContext = (INoMapContext)generatingContext;
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipMapItems) {
                    noMapContext.disabledMaps();
                }
            }
            extraItems = ((LootTable)((Registry)context.getLevel().getServer().reloadableRegistries().get().registry(Registries.LOOT_TABLE).get()).get(this.lootTableId)).getRandomItems(generatingContext);
        }
        catch (Exception e) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.warn("Loot generation of modifier:" + String.valueOf(this.location) + " for context failed for:" + String.valueOf(this.lootTableId), (Throwable)e);
            }
            return;
        }
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput && !inbuiltTables.contains(this.lootTableId)) {
            LootintegrationsMod.LOGGER.info("Adding loot to: " + String.valueOf(LootintegrationsMod.getLootTableId(lootTable, context.getLevel().getServer())) + " from: " + String.valueOf(this.lootTableId) + " caused by:" + String.valueOf(this.location));
        }
        if (extraItems.isEmpty()) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.info("Could not generate items for loottable: " + String.valueOf(this.lootTableId));
            }
            return;
        }
        int itemCount = this.integratedTables.getOrDefault(LootintegrationsMod.getLootTableId(lootTable, context.getLevel().getServer()), 1);
        if ((extraItems = this.aggregateStacks((List<ItemStack>)extraItems, false)).isEmpty()) {
            return;
        }
        if (!generatedLoot.isEmpty() && generatedLoot.size() + itemCount > this.fillSize) {
            List<ItemStack> newList = this.aggregateStacks(generatedLoot, true);
            generatedLoot.clear();
            generatedLoot.addAll(newList);
            if (generatedLoot.size() > this.fillSize) {
                int size = Math.min(generatedLoot.size(), generatedLoot.size() + itemCount - this.fillSize);
                for (int i2 = 0; i2 < size; ++i2) {
                    generatedLoot.remove(LootintegrationsMod.rand.nextInt(generatedLoot.size()));
                }
            }
        }
        if (itemCount == 0) {
            return;
        }
        int[] weights = new int[extraItems.size()];
        int totalWeight = 0;
        int size = extraItems.size();
        for (i = 0; i < size; ++i) {
            weight = this.calcWeightForStack((ItemStack)extraItems.get(i));
            weights[i] = totalWeight += weight;
        }
        for (i = 0; i < itemCount; ++i) {
            if (totalWeight <= 0) {
                return;
            }
            weight = LootintegrationsMod.rand.nextInt(totalWeight);
            int index = -1;
            int removedWeight = 0;
            ItemStack stack = null;
            for (int j = 0; j < size; ++j) {
                if (index == -1 && weight < weights[j]) {
                    index = j;
                    weights[j] = 0;
                    stack = (ItemStack)extraItems.get(index);
                    removedWeight = this.calcWeightForStack(stack);
                    totalWeight -= removedWeight;
                    continue;
                }
                if (index == -1) continue;
                int n = j;
                weights[n] = weights[n] - removedWeight;
            }
            if (stack == null) continue;
            boolean sameItem = false;
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipExistingItems) {
                for (int j = 0; j < generatedLoot.size(); ++j) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)generatedLoot.get(j), (ItemStack)stack)) continue;
                    sameItem = true;
                    break;
                }
            }
            if (!sameItem) {
                generatedLoot.add(stack);
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                    LootintegrationsMod.LOGGER.info("Adding loot to: " + String.valueOf(LootintegrationsMod.getLootTableId(lootTable, context.getLevel().getServer())) + " item:" + stack.toString());
                }
            } else {
                --i;
            }
            if (extraItems.isEmpty()) break;
        }
    }

    private int calcWeightForStack(ItemStack stack) {
        return stack.getItemHolder().getKey().location().getNamespace().equals("minecraft") ? 1 : ((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).moddedItemWeight + 1;
    }

    private List<ItemStack> aggregateStacks(List<ItemStack> stacksIn, boolean originalLoot) {
        HashMap<Item, ItemStack> aggregated = new HashMap<Item, ItemStack>();
        for (ItemStack stack : stacksIn) {
            ItemStack contained = (ItemStack)aggregated.get(stack.getItem());
            if (stack.isEmpty() || !originalLoot && stack.is(LootModifierManager.IGNORED_FOR_LOOT)) continue;
            if (contained == null) {
                aggregated.put(stack.getItem(), stack);
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)contained)) continue;
            contained.setCount(Math.min(contained.getCount() + stack.getCount(), Math.max(1, contained.getMaxStackSize() / 2)));
        }
        return new ArrayList<ItemStack>(aggregated.values());
    }

    public static GlobalLootModifierIntegration read(ResourceLocation location, JsonElement data) {
        GlobalLootModifierIntegration modifier = new GlobalLootModifierIntegration(location);
        JsonObject jsonData = (JsonObject)data;
        modifier.lootTableId = ResourceLocation.tryParse((String)jsonData.get(LOOT_TABLE_ID).getAsString());
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput && !location.getPath().contains("lootintegrations_")) {
            LootintegrationsMod.LOGGER.info("Parsing loot modifiers for:" + String.valueOf(location) + " with loottable: " + String.valueOf(modifier.lootTableId));
        }
        if (jsonData.has(MAX_RESULT_ITEMCOUNT)) {
            modifier.fillSize = jsonData.get(MAX_RESULT_ITEMCOUNT).getAsInt();
        }
        HashMap<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
        for (Map.Entry element : jsonData.get(INTEGRATED_LOOT_TABLES).getAsJsonObject().entrySet()) {
            ResourceLocation integratedTable = ResourceLocation.tryParse((String)((String)element.getKey()));
            integratedTables.put(integratedTable, ((JsonElement)element.getValue()).getAsInt());
        }
        modifier.integratedTables = integratedTables;
        return modifier;
    }
}

