/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public enum LootType {
    UNKNOWN(new LootContextParamSet.Builder().build()),
    BLOCK(LootContextParamSets.BLOCK),
    BLOCK_USE(LootContextParamSets.BLOCK_USE),
    CHEST(LootContextParamSets.CHEST),
    FISHING(LootContextParamSets.FISHING),
    ENTITY(LootContextParamSets.ENTITY),
    EQUIPMENT(LootContextParamSets.EQUIPMENT),
    ARCHAEOLOGY(LootContextParamSets.ARCHAEOLOGY),
    GIFT(LootContextParamSets.GIFT),
    VAULT(LootContextParamSets.VAULT),
    PIGLIN_BARTER(LootContextParamSets.PIGLIN_BARTER),
    ADVANCEMENT_REWARD(LootContextParamSets.ADVANCEMENT_REWARD),
    ADVANCEMENT_ENTITY(LootContextParamSets.ADVANCEMENT_ENTITY),
    ADVANCEMENT_LOCATION(LootContextParamSets.ADVANCEMENT_LOCATION),
    COMMAND(LootContextParamSets.COMMAND),
    SELECTOR(LootContextParamSets.SELECTOR),
    SHEARING(LootContextParamSets.SHEARING),
    GENERIC(LootContextParamSets.ALL_PARAMS);

    private static final Map<LootContextParamSet, LootType> MAPPINGS;
    private final LootContextParamSet paramSet;

    public static LootType getLootType(LootContextParamSet paramSet) {
        return MAPPINGS.getOrDefault(paramSet, UNKNOWN);
    }

    private LootType(LootContextParamSet paramSet) {
        this.paramSet = paramSet;
    }

    public LootContextParamSet getParamSet() {
        return this.paramSet;
    }

    static {
        MAPPINGS = (Map)Util.make(new HashMap(), m -> {
            for (LootType lootType : LootType.values()) {
                m.put(lootType.getParamSet(), lootType);
            }
        });
    }
}

