/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.chunk;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;

public class LoadedChunks {
    private static final Map<ResourceKey<Level>, Set<ChunkPos>> LOADED_CHUNKS = new ConcurrentHashMap<ResourceKey<Level>, Set<ChunkPos>>();

    public static void onChunkLoad(LevelAccessor level, LevelChunk chunk) {
        if (!level.isClientSide() && chunk.getFullStatus().isOrAfter(FullChunkStatus.FULL)) {
            ResourceKey dimension = chunk.getLevel().dimension();
            Set chunkSet = LOADED_CHUNKS.computeIfAbsent((ResourceKey<Level>)dimension, k -> ConcurrentHashMap.newKeySet());
            chunkSet.add(chunk.getPos());
        }
    }

    public static void onChunkUnload(LevelAccessor level, LevelChunk chunk) {
        ResourceKey dimension;
        Set<ChunkPos> chunkSet;
        if (!level.isClientSide() && (chunkSet = LOADED_CHUNKS.get(dimension = chunk.getLevel().dimension())) != null) {
            chunkSet.remove(chunk.getPos());
        }
    }

    public static Set<ChunkPos> getLoadedChunks(ResourceKey<Level> dimension) {
        Set set = LOADED_CHUNKS.computeIfAbsent(dimension, k -> ConcurrentHashMap.newKeySet());
        return Collections.unmodifiableSet(set);
    }

    public static void clear() {
        LOADED_CHUNKS.clear();
    }
}

