/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.gen.optionals;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.DetectedVersion;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import noobanidus.mods.lootr.common.api.LootrAPI;

@EventBusSubscriber(modid="lootr")
public class LootrNoAdvancementGenerator {
    private static final List<DataGenerator> generators = new ArrayList<DataGenerator>();

    private static DataGenerator makeGenerator(Path path, Component description) {
        DataGenerator generator = new DataGenerator(path, DetectedVersion.tryDetectVersion(), true);
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(generator.getPackOutput()).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection(description, 15, Optional.empty())));
        generators.add(generator);
        return generator;
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        Path root = output.getOutputFolder().getParent().getParent().getParent().getParent();
        Path datapacks = root.resolve("datapacks");
        DataGenerator generator = LootrNoAdvancementGenerator.makeGenerator(datapacks.resolve("lootr_no_advancements"), (Component)Component.literal((String)"Disable Lootr Advancements"));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(generator.getPackOutput(), provider, helper, List.of(new LootrAdvancementGenerator())));
        try {
            for (DataGenerator toRun : generators) {
                toRun.run();
                Files.copy(root.resolve("logo.png"), toRun.getPackOutput().getOutputFolder().resolve("pack.png"), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LootrAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider arg, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            Criterion impossible = CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
            AdvancementHolder lootrRoot = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("root"), existingFileHelper);
            AdvancementHolder one_barrel = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("1barrel"), existingFileHelper);
            AdvancementHolder one_cart = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("1cart"), existingFileHelper);
            AdvancementHolder one_chest = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("1chest"), existingFileHelper);
            AdvancementHolder one_shulker = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("1shulker"), existingFileHelper);
            AdvancementHolder brush = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("all_gravel"), existingFileHelper);
            AdvancementHolder pot = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("pot_opened"), existingFileHelper);
            AdvancementHolder archaeologist = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("archaeologist"), existingFileHelper);
            AdvancementHolder item_frame = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("1frame"), existingFileHelper);
            AdvancementHolder ten_loot = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("10loot"), existingFileHelper);
            AdvancementHolder twentyfive_loot = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("25loot"), existingFileHelper);
            AdvancementHolder fifty_loot = Advancement.Builder.advancement().addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("50loot"), existingFileHelper);
            Advancement.Builder.advancement().parent(fifty_loot).addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("100loot"), existingFileHelper);
            Advancement.Builder.advancement().parent(one_chest).addCriterion("impossible", impossible).save(consumer, LootrAPI.rl("social"), existingFileHelper);
        }
    }
}

