/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.gen.optionals;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import noobanidus.mods.lootr.common.api.LootrTags;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="lootr")
public class LootrNoSuspiciousGenerator {
    private static final List<DataGenerator> generators = new ArrayList<DataGenerator>();

    private static DataGenerator makeGenerator(Path path, Component description) {
        DataGenerator generator = new DataGenerator(path, DetectedVersion.tryDetectVersion(), true);
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(generator.getPackOutput()).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection(description, 15, Optional.empty())));
        generators.add(generator);
        return generator;
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        Path root = output.getOutputFolder().getParent().getParent().getParent().getParent();
        Path datapacks = root.resolve("datapacks");
        DataGenerator generator = LootrNoSuspiciousGenerator.makeGenerator(datapacks.resolve("lootr_no_suspicious_blocks"), (Component)Component.literal((String)"Disable Lootr Suspicious Sand and Gravel"));
        generator.addProvider(event.includeServer(), (DataProvider)new LootrBlockTagProvider(generator.getPackOutput(), provider, helper));
        try {
            for (DataGenerator toRun : generators) {
                toRun.run();
                Files.copy(root.resolve("logo.png"), toRun.getPackOutput().getOutputFolder().resolve("pack.png"), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LootrBlockTagProvider
    extends BlockTagsProvider {
        public LootrBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "lootr", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(LootrTags.Blocks.CONVERT_SANDS).replace();
            this.tag(LootrTags.Blocks.CONVERT_GRAVELS).replace();
        }

        public String getName() {
            return "Lootr Block Tags";
        }
    }
}

