/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.model.RotatedModelPart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public class MalignantStrongholdArmorModel
extends LodestoneArmorModel {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(MalumMod.malumPath("malignant_lead_armor"), "main");
    public ModelPart scarf;
    public RotatedModelPart lowerScarf;
    public RotatedModelPart middleScarf;
    public RotatedModelPart upperScarf;

    public MalignantStrongholdArmorModel(ModelPart root) {
        super(root);
        this.scarf = root.getChild("scarf");
        this.lowerScarf = RotatedModelPart.of(this.scarf.getChild("lower_scarf"));
        this.middleScarf = RotatedModelPart.of(this.scarf.getChild("middle_scarf"));
        this.upperScarf = RotatedModelPart.of(this.scarf.getChild("upper_scarf"));
    }

    protected Iterable<ModelPart> bodyParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.scarf);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.leftLegging, (Object)this.rightLegging, (Object)this.leggings);
        }
        return this.slot == EquipmentSlot.FEET ? ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot) : ImmutableList.of();
    }

    public void copyFromDefault(HumanoidModel model) {
        super.copyFromDefault(model);
        this.scarf.copyFrom(model.body);
        model.hat.visible = false;
    }

    public void setupAnim(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float pPartialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        if (pEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)pEntity;
            double d0 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.xCloakO, (double)clientPlayer.xCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.xo, (double)pEntity.getX());
            double d1 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.yCloakO, (double)clientPlayer.yCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.yo, (double)pEntity.getY());
            double d2 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.zCloakO, (double)clientPlayer.zCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.zo, (double)pEntity.getZ());
            float f = pEntity.yBodyRotO + (pEntity.yBodyRot - pEntity.yBodyRotO);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)16.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 65.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)75.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)pPartialTicks, (float)clientPlayer.oBob, (float)clientPlayer.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)pPartialTicks, (float)pEntity.walkDistO, (float)pEntity.walkDist) * 6.0f)) * 32.0f * f4;
            if (pEntity.isCrouching()) {
                f1 += 25.0f;
            }
            float x = (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
            float y = (float)Math.toRadians(f3 / 2.0f);
            float z = (float)Math.toRadians(f3 / 2.0f);
            this.lowerScarf.setRotation(x / 2.0f, y / 2.0f, z / 2.0f);
            this.middleScarf.setRotation(x, y, z);
            this.upperScarf.setRotation(x, y, z);
        } else {
            this.lowerScarf.setRotation(0.0f, 0.0f, 0.0f);
            this.middleScarf.setRotation(0.0f, 0.0f, 0.0f);
            this.upperScarf.setRotation(0.0f, 0.0f, 0.0f);
        }
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    public static LayerDefinition createBodyLayer() {
        return MalignantStrongholdArmorModel.createArmorModel((mesh, root, body, leggings, right_legging, left_legging, right_foot, left_foot, right_arm, left_arm, head) -> {
            PartDefinition scarf = root.addOrReplaceChild("scarf", new CubeListBuilder(), PartPose.ZERO);
            PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 29).addBox(-4.0f, -9.5f, -5.0f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.01f)).texOffs(0, 17).addBox(-4.5f, -6.5f, -1.5f, 9.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 29).mirror().addBox(1.0f, -9.5f, -5.0f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(0, 0).addBox(-1.5f, -10.5f, -5.5f, 3.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(28, 1).addBox(-5.5f, -11.5f, -4.5f, 2.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(28, 1).mirror().addBox(3.5f, -11.5f, -4.5f, 2.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(42, 4).addBox(-6.5f, -8.0f, -5.5f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 4).mirror().addBox(2.5f, -8.0f, -5.5f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(62, 29).addBox(-4.0f, -9.5f, -5.0f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.3f)).texOffs(62, 17).addBox(-4.5f, -6.5f, -1.5f, 9.0f, 6.0f, 6.0f, new CubeDeformation(0.3f)).texOffs(62, 29).mirror().addBox(1.0f, -9.5f, -5.0f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.3f)).mirror(false).texOffs(62, 0).addBox(-1.5f, -10.5f, -5.5f, 3.0f, 6.0f, 11.0f, new CubeDeformation(0.3f)).texOffs(90, 1).addBox(-5.5f, -11.5f, -4.5f, 2.0f, 6.0f, 10.0f, new CubeDeformation(0.3f)).texOffs(90, 1).mirror().addBox(3.5f, -11.5f, -4.5f, 2.0f, 6.0f, 10.0f, new CubeDeformation(0.3f)).mirror(false).texOffs(104, 4).addBox(-6.5f, -8.0f, -5.5f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.3f)).texOffs(104, 4).mirror().addBox(2.5f, -8.0f, -5.5f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cover = helmet.addOrReplaceChild("cover", CubeListBuilder.create().texOffs(27, 29).mirror().addBox(2.5f, -5.222f, -4.8053f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(27, 29).addBox(-5.5f, -5.222f, -4.8053f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(15, 29).addBox(-2.5f, -5.222f, -4.8053f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(77, 29).addBox(-2.5f, -5.222f, -4.8053f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(89, 29).mirror().addBox(2.5f, -5.222f, -4.8053f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(89, 29).addBox(-5.5f, -5.222f, -4.8053f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
            PartDefinition left_guard = helmet.addOrReplaceChild("left_guard", CubeListBuilder.create().texOffs(17, 0).mirror().addBox(-1.5f, -1.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(79, 0).mirror().addBox(-1.5f, -1.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-5.5f, (float)-2.35f, (float)0.0f, (float)0.0f, (float)-0.2618f));
            PartDefinition right_guard = helmet.addOrReplaceChild("right_guard", CubeListBuilder.create().texOffs(17, 0).addBox(-1.5f, -1.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(79, 0).addBox(-1.5f, -1.0f, -2.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)-4.0f, (float)-5.5f, (float)-2.35f, (float)0.0f, (float)0.0f, (float)0.2618f));
            PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 49).addBox(-5.0f, 2.0f, -3.0f, 10.0f, 5.0f, 6.0f, new CubeDeformation(0.025f)).texOffs(0, 60).addBox(-4.5f, 6.5f, -2.5f, 9.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(62, 49).addBox(-5.0f, 2.0f, -3.0f, 10.0f, 5.0f, 6.0f, new CubeDeformation(0.275f)).texOffs(62, 60).addBox(-4.5f, 6.5f, -2.5f, 9.0f, 4.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cuirass = torso.addOrReplaceChild("cuirass", CubeListBuilder.create().texOffs(15, 36).addBox(-6.0f, -0.95f, -4.925f, 12.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(77, 36).addBox(-6.0f, -0.95f, -4.925f, 12.0f, 4.0f, 9.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
            PartDefinition lower_scarf = scarf.addOrReplaceChild("lower_scarf", CubeListBuilder.create().texOffs(0, 112).addBox(-5.5f, 2.05f, 4.075f, 11.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
            PartDefinition middle_scarf = scarf.addOrReplaceChild("middle_scarf", CubeListBuilder.create().texOffs(40, 101).addBox(-3.5f, -0.95f, 4.325f, 7.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
            PartDefinition upper_scarf = scarf.addOrReplaceChild("upper_scarf", CubeListBuilder.create().texOffs(41, 92).addBox(-4.5f, -0.95f, 1.575f, 9.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
            PartDefinition left_shoulder = left_arm.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(33, 49).addBox(3.0f, -4.5f, -3.0f, 2.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).texOffs(22, 109).addBox(2.0f, 2.0f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).texOffs(0, 69).addBox(0.0f, -5.5f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).texOffs(95, 49).addBox(3.0f, -4.5f, -3.0f, 2.0f, 5.0f, 6.0f, new CubeDeformation(0.26f)).texOffs(62, 69).addBox(0.0f, -5.5f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.26f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_shoulder_pad = left_shoulder.addOrReplaceChild("left_shoulder_pad", CubeListBuilder.create().texOffs(20, 61).addBox(1.8918f, -1.4882f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.01f)).texOffs(82, 61).addBox(1.8918f, -1.4882f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.26f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
            PartDefinition right_shoulder = right_arm.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(33, 49).mirror().addBox(-5.0f, -4.5f, -3.0f, 2.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(0, 69).mirror().addBox(-3.0f, -5.5f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(22, 109).mirror().addBox(-5.0f, 2.0f, -3.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(95, 49).mirror().addBox(-5.0f, -4.5f, -3.0f, 2.0f, 5.0f, 6.0f, new CubeDeformation(0.26f)).mirror(false).texOffs(62, 69).mirror().addBox(-3.0f, -5.5f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.26f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_shoulder_pad = right_shoulder.addOrReplaceChild("right_shoulder_pad", CubeListBuilder.create().texOffs(20, 61).mirror().addBox(-7.6753f, -1.4644f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(82, 61).mirror().addBox(-7.6753f, -1.4644f, -4.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.26f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
            PartDefinition left_leg = left_legging.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 81).mirror().addBox(-2.4f, -0.5f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(62, 81).mirror().addBox(-2.4f, -0.5f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_thigh_guard_right = left_leg.addOrReplaceChild("left_thigh_guard_right", CubeListBuilder.create().texOffs(18, 72).mirror().addBox(1.3934f, -2.3778f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.05f)).mirror(false).texOffs(80, 72).mirror().addBox(1.3934f, -2.3778f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offsetAndRotation((float)0.1f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
            PartDefinition left_thigh_guard_bottom = left_leg.addOrReplaceChild("left_thigh_guard_bottom", CubeListBuilder.create().texOffs(18, 72).mirror().addBox(-0.2266f, -2.1443f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.02f)).mirror(false).texOffs(80, 72).mirror().addBox(-0.2266f, -2.1443f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.27f)).mirror(false), PartPose.offsetAndRotation((float)1.1f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
            PartDefinition left_leg_cloth_l = left_leg.addOrReplaceChild("left_leg_cloth_l", CubeListBuilder.create().texOffs(22, 95).mirror().addBox(-0.5f, -2.0f, -3.0f, 3.0f, 8.0f, 6.0f, new CubeDeformation(0.13f)).mirror(false).texOffs(84, 95).mirror().addBox(-0.5f, -2.0f, -3.0f, 3.0f, 8.0f, 6.0f, new CubeDeformation(0.38f)).mirror(false), PartPose.offsetAndRotation((float)-0.9f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
            PartDefinition right_leg = right_legging.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 81).addBox(-2.6f, -0.5f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(62, 81).addBox(-2.6f, -0.5f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_thigh_guard_top = right_leg.addOrReplaceChild("right_thigh_guard_top", CubeListBuilder.create().texOffs(18, 72).addBox(-4.3934f, -2.3778f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.05f)).texOffs(80, 72).addBox(-4.3934f, -2.3778f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)-0.1f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
            PartDefinition right_thigh_guard_bottom = right_leg.addOrReplaceChild("right_thigh_guard_bottom", CubeListBuilder.create().texOffs(18, 72).addBox(-2.7734f, -2.1443f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.02f)).texOffs(80, 72).addBox(-2.7734f, -2.1443f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.27f)), PartPose.offsetAndRotation((float)-1.1f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
            PartDefinition right_leg_cloth_r = right_leg.addOrReplaceChild("right_leg_cloth_r", CubeListBuilder.create().texOffs(22, 95).addBox(-2.5f, -2.0f, -3.0f, 3.0f, 8.0f, 6.0f, new CubeDeformation(0.13f)).texOffs(84, 95).addBox(-2.5f, -2.0f, -3.0f, 3.0f, 8.0f, 6.0f, new CubeDeformation(0.38f)), PartPose.offsetAndRotation((float)0.9f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
            PartDefinition codpiece = leggings.addOrReplaceChild("codpiece", CubeListBuilder.create().texOffs(36, 76).addBox(-4.5f, 9.5f, -3.0f, 9.0f, 2.0f, 6.0f, new CubeDeformation(0.06f)).texOffs(98, 76).addBox(-4.5f, 9.5f, -3.0f, 9.0f, 2.0f, 6.0f, new CubeDeformation(0.31f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition codpiece_cloth = codpiece.addOrReplaceChild("codpiece_cloth", CubeListBuilder.create().texOffs(0, 95).addBox(-2.5f, 6.5f, -3.0f, 5.0f, 11.0f, 6.0f, new CubeDeformation(0.15f)).texOffs(62, 95).addBox(-2.5f, 6.5f, -3.0f, 5.0f, 11.0f, 6.0f, new CubeDeformation(0.4f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_boot = left_foot.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(20, 84).addBox(-2.9f, 8.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).texOffs(82, 84).addBox(-2.9f, 8.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.26f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_boot = right_foot.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(20, 84).mirror().addBox(-3.1f, 8.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(82, 84).mirror().addBox(-3.1f, 8.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
        });
    }
}

