/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model;

import net.minecraft.client.model.geom.ModelPart;

public class RotatedModelPart {
    private final ModelPart part;
    private final float baseXRot;
    private final float baseYRot;
    private final float baseZRot;
    private float xRot;
    private float yRot;
    private float zRot;

    private RotatedModelPart(ModelPart part) {
        this.part = part;
        this.baseXRot = part.xRot;
        this.baseYRot = part.yRot;
        this.baseZRot = part.zRot;
    }

    public static RotatedModelPart of(ModelPart part) {
        return new RotatedModelPart(part);
    }

    public ModelPart getPart() {
        return this.part;
    }

    public void setRotation(float xRot, float yRot, float zRot) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
        this.applyRotation();
    }

    public void applyRotation() {
        this.part.xRot = this.baseXRot + this.xRot;
        this.part.yRot = this.baseYRot + this.yRot;
        this.part.zRot = this.baseZRot + this.zRot;
    }

    public void setVisible(boolean visible) {
        this.part.visible = visible;
    }

    public void copyFrom(ModelPart other) {
        this.part.copyFrom(other);
    }
}

