/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;

public class SpiritJarRenderer
implements BlockEntityRenderer<SpiritJarBlockEntity> {
    public SpiritJarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SpiritJarBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ClientLevel level = Minecraft.getInstance().level;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        if (blockEntityIn.contents != null) {
            SpiritArcanaType type = blockEntityIn.contents.getSpirit();
            float time = (float)level.getGameTime() + partialTicks;
            double y = 0.5f + (float)Math.sin(time * 0.05f % 6.28f) * 0.2f;
            poseStack.pushPose();
            poseStack.translate(0.5, y, 0.5);
            FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, type, partialTicks);
            poseStack.mulPose(Axis.YP.rotationDegrees(time * 3.0f % 360.0f));
            poseStack.scale(0.6f, 0.6f, 0.6f);
            itemRenderer.renderStatic(type.getSpiritStack(), ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
    }
}

