/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.common.block.curiosities.void_depot.VoidDepotBlockEntity;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.client.MalumRenderTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class VoidDepotRenderer
implements BlockEntityRenderer<VoidDepotBlockEntity> {
    private static final MultiBufferSource ADDITIVE = new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)LodestoneRenderHandler.LATE_DEFERRED_RENDER.getTarget());
    private static final MultiBufferSource TRANSPARENT = new LodestoneBufferWrapper(LodestoneRenderTypes.TRANSPARENT_TEXT, (MultiBufferSource)LodestoneRenderHandler.DEFERRED_RENDER.getTarget());

    public VoidDepotRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VoidDepotBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float height = 0.9375f;
        float width = 0.3125f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-width, height, width), new Vector3f(width, height, width), new Vector3f(width, height, -width), new Vector3f(-width, height, -width)};
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.01f, 0.5f);
        builder.replaceBufferSource((MultiBufferSource)LodestoneRenderHandler.LATE_DEFERRED_RENDER.getTarget()).setRenderType(LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.VOID_VIGNETTE)).renderQuad(poseStack, positions, 1.0f);
        long gameTime = blockEntityIn.getLevel().getGameTime();
        float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
        float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
        float alpha = 0.05f;
        LodestoneRenderTypeBuilder distortion = MalumRenderTypes.WEEPING_WELL_DISTORTED_TEXTURE.apply(MalumRenderTypeTokens.VOID_NOISE);
        builder.replaceBufferSource((MultiBufferSource)LodestoneRenderHandler.DEFERRED_RENDER.getTarget());
        for (int i = 0; i < 2; ++i) {
            float speed = 1000.0f + 250.0f * (float)i;
            ShaderUniformHandler uniforms = new ShaderUniformHandler().modifyUniform("Speed", new float[]{speed}).modifyUniform("Width", new float[]{16.0f}).modifyUniform("Height", new float[]{16.0f});
            builder.setColor(MalumSpiritTypes.WICKED_SPIRIT.getPrimaryColor()).setRenderType(distortion.withUniformHandler(uniforms));
            builder.setAlpha(alpha);
            builder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderQuad(poseStack, positions, 1.0f);
            builder.setUV(uOffset, -vOffset, 1.0f + uOffset, 1.0f - vOffset).renderQuad(poseStack, positions, 1.0f);
            alpha -= 0.0125f;
            uOffset = -uOffset - 0.2f;
            vOffset = -vOffset + 0.4f;
            poseStack.translate(0.0f, 0.05f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            if (i != 0) continue;
            builder.setColor(MalumSpiritTypes.ELDRITCH_SPIRIT.getPrimaryColor());
        }
        poseStack.popPose();
        if (blockEntityIn.textVisibility > 12.0f) {
            Font font = Minecraft.getInstance().font;
            float timer = Mth.clamp((float)(blockEntityIn.textVisibility + (float)(blockEntityIn.nearTimer > 0 ? 1 : -1) * partialTicks), (float)0.0f, (float)40.0f);
            float scalar = Easing.SINE_IN_OUT.ease(timer / 40.0f, 0.0f, 1.0f, 1.0f);
            float scale = 0.016f - (1.0f - scalar) * 0.004f;
            Font.DisplayMode display = Font.DisplayMode.NORMAL;
            List<VoidDepotBlockEntity.VoidDepotGoal> goals = blockEntityIn.goals;
            List components = new ArrayList<MutableComponent>();
            if (!blockEntityIn.goals.isEmpty()) {
                components = goals.stream().map(g -> Component.literal((String)(g.index + ": <" + g.deliveredAmount + "/" + g.amount + ">"))).collect(Collectors.toCollection(ArrayList::new));
            }
            components.addAll(blockEntityIn.textToDisplay.stream().map(Component::literal).toList());
            poseStack.pushPose();
            poseStack.translate(0.5f, 2.0f, 0.5f);
            poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            for (int i = 0; i < components.size(); ++i) {
                for (int j = 0; j < 2; ++j) {
                    MutableComponent text = ((MutableComponent)components.get(i)).copy();
                    boolean isAdditive = j == 0;
                    MultiBufferSource bufferToUse = isAdditive ? ADDITIVE : TRANSPARENT;
                    MutableComponent outlineText = text.copy();
                    text.withStyle(isAdditive ? style -> style.withColor(TextColor.fromRgb((int)MalumSpiritTypes.WICKED_SPIRIT.getPrimaryColor().getRGB())) : style -> style.withColor(TextColor.fromRgb((int)new Color(50, 0, 50).getRGB())));
                    outlineText.withStyle(isAdditive ? ChatFormatting.RED : ChatFormatting.BLACK);
                    poseStack.pushPose();
                    Matrix4f pose = poseStack.last().pose();
                    poseStack.translate(0.0f, (float)i * 0.15f, 0.0f);
                    if (isAdditive) {
                        poseStack.translate(0.0f, 0.0f, 0.05f);
                    }
                    poseStack.scale(scale, -scale, -scale);
                    float offset = isAdditive ? 0.4f : 0.8f;
                    float f = (float)(-font.width((FormattedText)text)) / 2.0f;
                    float xPos = 0.0f + f;
                    int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.3f : 0.9f) * scalar));
                    font.drawInBatch((Component)text, xPos, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.15f : 0.7f) * scalar));
                    font.drawInBatch((Component)text, xPos - offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)text, xPos - offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)text, xPos, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)text, xPos, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.1f : 0.5f) * scalar));
                    font.drawInBatch((Component)text, xPos - 2.0f * offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)outlineText, xPos + 2.0f * offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)outlineText, xPos, 2.0f * offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)text, xPos, -2.0f * offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)outlineText, xPos - offset, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)text, xPos - offset, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)outlineText, xPos + offset, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.drawInBatch((Component)text, xPos + offset, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    poseStack.popPose();
                }
            }
            poseStack.popPose();
        }
    }
}

