/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;

public class BookEntryBuilder {
    protected final String identifier;
    protected final boolean isVoid;
    protected List<BookPage> pages = new ArrayList<BookPage>();
    protected List<EntryReference> references = new ArrayList<EntryReference>();
    protected BooleanSupplier condition = () -> true;
    protected SpiritLike associatedSpirit;
    protected UnaryOperator<Style> titleStyle;
    protected UnaryOperator<Style> subtitleStyle;
    protected boolean hasTooltip = true;

    protected BookEntryBuilder(String identifier, boolean isVoid) {
        this.identifier = identifier;
        this.isVoid = isVoid;
        this.titleStyle = style -> style.withColor(isVoid ? ChatFormatting.DARK_PURPLE : ChatFormatting.GOLD);
        this.subtitleStyle = style -> style.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true));
    }

    public BookEntryBuilder(String identifier) {
        this(identifier, identifier.startsWith("void.") || BookPage.isVoidThemed);
    }

    public BookEntryBuilder addPage(BookPage page) {
        if (page.isValid()) {
            this.pages.add(page);
        }
        return this;
    }

    public BookEntryBuilder addReference(EntryReference reference) {
        this.references.add(reference);
        return this;
    }

    public BookEntryBuilder setEntryCondition(BooleanSupplier condition) {
        this.condition = condition;
        return this;
    }

    public BookEntryBuilder setAssociatedSpirit(SpiritLike associatedSpirit) {
        this.associatedSpirit = associatedSpirit;
        return this;
    }

    public BookEntryBuilder afterSomeTime() {
        this.condition = BookEntry.AFTER_SOME_TIME;
        return this;
    }

    public BookEntryBuilder afterVoidReader() {
        this.condition = BookEntry.AFTER_VOID_READER;
        return this;
    }

    public BookEntryBuilder afterUmbralCrystal() {
        this.condition = BookEntry.AFTER_UMBRAL_CRYSTAL;
        return this;
    }

    public BookEntryBuilder withTitleStyle(UnaryOperator<Style> styleFunction) {
        UnaryOperator<Style> existingStyle = this.titleStyle;
        this.titleStyle = style -> (Style)styleFunction.apply((Style)existingStyle.apply((Style)style));
        return this;
    }

    public BookEntryBuilder withSubtitleStyle(UnaryOperator<Style> styleFunction) {
        UnaryOperator<Style> existingStyle = this.subtitleStyle;
        this.subtitleStyle = style -> (Style)styleFunction.apply((Style)existingStyle.apply((Style)style));
        return this;
    }

    public BookEntryBuilder disableTooltip() {
        this.hasTooltip = false;
        return this;
    }

    public BookEntry build() {
        ImmutableList bookPages = ImmutableList.copyOf(this.pages);
        ImmutableList entryReferences = ImmutableList.copyOf(this.references);
        return new BookEntry(this.identifier, this.isVoid, (ImmutableList<BookPage>)bookPages, (ImmutableList<EntryReference>)entryReferences, this.condition, this.associatedSpirit, false, this.titleStyle, this.subtitleStyle, this.hasTooltip);
    }
}

