/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRecipe;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SpiritRepairPage
extends BookPage {
    private final SpiritRepairRecipe recipe;
    private final List<ItemStack> damagedStacks;
    private final List<ItemStack> repairedStacks;

    public SpiritRepairPage(Predicate<SpiritRepairRecipe> predicate) {
        this((SpiritRepairRecipe)LodestoneRecipeType.findRecipe((Level)Minecraft.getInstance().level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get()), predicate));
    }

    public SpiritRepairPage(SpiritRepairRecipe recipe) {
        super(MalumMod.malumPath("textures/gui/book/pages/spirit_repair_page.png"));
        this.recipe = recipe;
        this.damagedStacks = recipe != null ? recipe.getDamagedItems() : Collections.emptyList();
        this.repairedStacks = recipe != null ? recipe.getRepairedItems() : Collections.emptyList();
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    public static SpiritRepairPage fromOutput(Item outputItem) {
        return new SpiritRepairPage(recipe -> recipe.isValidItemForRepair((ItemLike)outputItem));
    }

    public static SpiritRepairPage fromId(String recipeId) {
        return SpiritRepairPage.fromId(MalumMod.malumPath(recipeId));
    }

    public static SpiritRepairPage fromId(ResourceLocation recipeId) {
        ClientLevel level = Minecraft.getInstance().level;
        ResourceLocation other = recipeId.withPrefix("spirit_repair/");
        SpiritRepairRecipe recipe = LodestoneRecipeType.getRecipeHolders((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get())).stream().filter(r -> r.id().equals((Object)other)).findFirst().map(RecipeHolder::value).orElse(null);
        return new SpiritRepairPage(recipe);
    }

    @Override
    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        CodexItemHelper.renderIngredients(screen, guiGraphics, this.recipe.spirits, left + 63, top + 16, mouseX, mouseY, false);
        CodexItemHelper.renderIngredients(screen, guiGraphics, List.of(this.recipe.repairMaterial), left + 63, top + 32, mouseX, mouseY, false);
        CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, guiGraphics, this.damagedStacks, left + 63, top + 56, mouseX, mouseY);
        CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, guiGraphics, this.repairedStacks, left + 63, top + 132, mouseX, mouseY);
        this.renderRecipeInfo(guiGraphics, screen, "spirit_repair", left + 62, top + 74, mouseX, mouseY);
    }
}

