/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.waveform;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.text.DecimalFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public abstract class AbstractValueConfigurationScreen
extends Screen {
    protected static final Function<GuiGraphics, LodestoneBufferWrapper> TEXT_WRAPPER_FUNCTION = Util.memoize(guiGraphics -> new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)guiGraphics.bufferSource));
    protected static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    protected static final ResourceLocation WIDGETS = MalumMod.malumPath("textures/gui/waveform_artifice/waveform_widgets.png");
    protected static final int FADE_SIZE = 6;
    protected static final int BORDER_SIZE = 5;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int interfaceWidth;
    protected final int interfaceHeight;
    protected int guiLeft;
    protected int guiTop;
    protected int xCenter;
    protected int yCenter;
    protected int dialLeft;
    protected int dialRight;
    protected int dialTop;
    protected int dialBottom;
    protected int xDialCenter;
    protected int yDialCenter;
    protected boolean disableMouse;
    protected int ticksOpen = 0;

    public AbstractValueConfigurationScreen(Component component, int screenWidth, int screenHeight, int interfaceWidth, int interfaceHeight) {
        super(component);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.interfaceWidth = interfaceWidth;
        this.interfaceHeight = interfaceHeight;
    }

    public static Component getTitleComponent(LodestoneBlockEntity blockEntity) {
        return AbstractValueConfigurationScreen.getTitleComponent(blockEntity.getBlockState().getBlock());
    }

    public static Component getTitleComponent(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return Component.translatable((String)("malum.waveform_artifice." + id.getPath()));
    }

    protected abstract void notifyServer(boolean var1);

    public abstract void updateMousePosition(double var1, double var3);

    protected abstract boolean hasChanged();

    protected void init() {
        this.guiLeft = (this.width - this.screenWidth) / 2;
        this.guiTop = (this.height - this.screenHeight) / 2;
        this.xCenter = this.guiLeft + this.screenWidth / 2;
        this.yCenter = this.guiTop + this.screenHeight / 2;
        this.dialLeft = this.xCenter - this.interfaceWidth / 2;
        this.dialRight = this.xCenter + this.interfaceWidth / 2;
        this.dialTop = this.guiTop + 20;
        this.dialBottom = this.dialTop + this.interfaceHeight;
        this.xDialCenter = this.dialLeft + this.interfaceWidth / 2;
        this.yDialCenter = this.dialTop + this.interfaceHeight / 2;
        this.notifyServer(true);
        Window window = this.minecraft.getWindow();
        double x = this.minecraft.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double y = this.minecraft.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        this.updateMousePosition(x, y);
    }

    public void playSound(Holder<SoundEvent> soundEvent) {
        LocalPlayer player = this.minecraft.player;
        ClientLevel level = this.minecraft.level;
        level.playSound((Player)player, player.blockPosition(), (SoundEvent)soundEvent.value(), SoundSource.BLOCKS, 0.8f, RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.9f, (float)1.1f));
    }

    public void tick() {
        super.tick();
        ++this.ticksOpen;
        if (this.hasChanged()) {
            this.playSound((Holder<SoundEvent>)MalumSoundEvents.SPIRIT_DIODE_TICK);
        }
        if (this.ticksOpen % 20 == 0) {
            this.notifyServer(true);
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.disableMouse = false;
    }

    public static boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        return mouseX > (double)posX && mouseX < (double)(posX + (float)width) && mouseY > (double)posY && mouseY < (double)(posY + (float)height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.playSound((Holder<SoundEvent>)MalumSoundEvents.SPIRIT_DIODE_LONG_TICK);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.disableMouse = true;
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        float delta = Math.min(1.0f, ((float)this.ticksOpen + partialTick) / 5.0f);
        int fadeXStart = (int)((float)this.guiLeft + (float)this.screenWidth * (0.5f - delta / 2.0f)) - 6;
        int fadeXEnd = (int)((float)this.guiLeft + (float)this.screenWidth * (0.5f + delta / 2.0f)) + 6;
        int fadeYStart = this.guiTop - 6;
        int fadeYEnd = this.guiTop + this.screenHeight + 6;
        int a = (int)(128.0f * delta) << 24;
        guiGraphics.fillGradient(fadeXStart, fadeYStart, fadeXEnd, fadeYEnd, 0x101010 | a, 0x101010 | a);
        guiGraphics.drawString(this.font, this.title, this.xCenter - this.font.width((FormattedText)this.title) / 2, this.guiTop, 0xDDDDDD, false);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + pPartialTick) / 20.0f)) << 24;
        graphics.fillGradient(0, 0, this.width, this.height, 0x101010 | a, 0x101010 | a);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyUse.matches(pKeyCode, pScanCode)) {
            this.onClose();
            return true;
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.minecraft.options.keyUse.matchesMouse(pButton)) {
            this.onClose();
            return true;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public void onClose() {
        this.notifyServer(false);
        super.onClose();
    }

    protected void setCursor(double mouseX, double mouseY) {
        double guiScale = this.minecraft.getWindow().getGuiScale();
        GLFW.glfwSetCursorPos((long)this.minecraft.getWindow().getWindow(), (double)(mouseX * guiScale), (double)(mouseY * guiScale));
    }

    protected void renderBorderBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        int startX = x - 5;
        int startY = y - 5;
        int endX = x + width;
        int endY = y + height;
        graphics.fillGradient(startX + 1, startY + 1, endX + 5 - 1, endY + 5 - 1, 0, -15793402, -15068396);
    }

    protected void renderTextWidget(GuiGraphics graphics, Component text, int x, int y, boolean powered, float pPartialTick) {
        int offset = powered ? 7 : 5;
        VFXBuilders.createScreen().setTexture(WIDGETS).setUVWithWidth(powered ? 0.0f : 7.0f, 16.0f, 7.0f, 12.0f, 32.0f).setPositionWithWidth((float)(x - offset), (float)y, 7.0f, 12.0f).blit(graphics.pose());
        this.renderText(graphics, text, x - this.font.width((FormattedText)text) - offset, (float)y + 1.5f, powered, pPartialTick);
    }

    public void renderBorder(GuiGraphics graphics, int x, int y, int width, int height) {
        int startX = x - 5;
        int startY = y - 5;
        int endX = x + width;
        int endY = y + height;
        this.renderWidgetTexture(graphics, startX, startY, 0, 0, 5, 5);
        this.renderWidgetTexture(graphics, endX, startY, 9, 0, 5, 5);
        this.renderWidgetTexture(graphics, endX, endY, 9, 9, 5, 5);
        this.renderWidgetTexture(graphics, startX, endY, 0, 9, 5, 5);
        this.renderWidgetTexture(graphics, startX + 5, startY, 6, 0, endX - startX - 5, 4, 2, 4);
        this.renderWidgetTexture(graphics, startX + 5, endY + 1, 6, 10, endX - startX - 5, 4, 2, 4);
        this.renderWidgetTexture(graphics, startX, startY + 5, 0, 6, 4, endY - startY - 5, 4, 2);
        this.renderWidgetTexture(graphics, endX + 1, startY + 5, 10, 6, 4, endY - startY - 5, 4, 2);
    }

    public void renderWidgetTexture(GuiGraphics graphics, int x, int y, int u, int v, int width, int height) {
        VFXBuilders.createScreen().setTexture(WIDGETS).setPositionWithWidth((float)x, (float)y, (float)width, (float)height).setUVWithWidth((float)u, (float)v, (float)width, (float)height, 32.0f).blit(graphics.pose());
    }

    public void renderWidgetTexture(GuiGraphics graphics, int x, int y, int u, int v, int xCoverage, int yCoverage, int width, int height) {
        VFXBuilders.createScreen().setTexture(WIDGETS).setPositionWithWidth((float)x, (float)y, (float)xCoverage, (float)yCoverage).setUVWithWidth((float)u, (float)v, (float)width, (float)height, 32.0f).blit(graphics.pose());
    }

    protected void renderText(GuiGraphics guiGraphics, Component component, float x, float y, boolean isPowered, float partialTick) {
        String text = component.getString();
        Font font = this.minecraft.font;
        guiGraphics.drawString(font, text, x - 1.0f, y, -2144204278, false);
        guiGraphics.drawString(font, text, x + 1.0f, y, 1345456650, false);
        guiGraphics.drawString(font, text, x, y - 1.0f, 1352865816, false);
        guiGraphics.drawString(font, text, x, y + 1.0f, 1613892106, false);
        guiGraphics.drawString(font, text, x, y, 10688536, false);
        if (isPowered) {
            float gameTime = (float)this.minecraft.level.getGameTime() + partialTick;
            int alpha = Mth.floor((float)(255.0f * (0.4f + Mth.abs((float)(0.3f * Mth.sin((float)(gameTime / 20.0f % 6.28f)))))));
            int base = alpha << 24 | 0xE61919;
            int dim = base & 0xFFFFFF | alpha / 3 << 24;
            int dimmer = base & 0xFFFFFF | alpha / 6 << 24;
            LodestoneBufferWrapper buffer = TEXT_WRAPPER_FUNCTION.apply(guiGraphics);
            Matrix4f pose = guiGraphics.pose().last().pose();
            RenderSystem.enableBlend();
            float offsetMultiplier = Mth.sin((float)(gameTime / 10.0f % 6.28f));
            float xOffset = 1.25f * offsetMultiplier;
            float yOffset = 2.0f * offsetMultiplier;
            font.drawInBatch(text, x, y, base, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x + 1.0f, y, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x - 1.0f, y, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y + 1.0f, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y - 1.0f, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x + xOffset, y, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x - xOffset, y, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y + yOffset, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y - yOffset, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            RenderSystem.defaultBlendFunc();
        }
    }

    public void renderDial(GuiGraphics graphics, ResourceLocation texture, int x, int y) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(10.0f);
        shaderInstance.safeGetUniform("Speed").set(400.0f);
        shaderInstance.safeGetUniform("Intensity").set(100.0f);
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setAlpha(0.9f).setColor(0.7f, 0.1f, 0.1f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((int)770, (int)1);
        this.renderDialTexture(graphics, builder, texture, x, y);
        builder.setAlpha(0.2f);
        shaderInstance.safeGetUniform("Speed").set(800.0f);
        this.renderDialTexture(graphics, builder, texture, x - 1, y);
        this.renderDialTexture(graphics, builder, texture, x + 1, y);
        this.renderDialTexture(graphics, builder, texture, x, y - 1);
        this.renderDialTexture(graphics, builder, texture, x, y + 1);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public void renderDialOverlay(GuiGraphics graphics, ResourceLocation texture, int x, int y, int angle, float range, float alpha) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.RADIAL_DISTORTED_SCREEN_LIGHT.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(10.0f);
        shaderInstance.safeGetUniform("Speed").set(400.0f);
        shaderInstance.safeGetUniform("Intensity").set(100.0f);
        shaderInstance.safeGetUniform("Angle").set(angle);
        shaderInstance.safeGetUniform("LightAngleRange").set(range);
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setAlpha(0.95f * alpha).setColor(0.5f, 0.2f, 0.7f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((int)770, (int)1);
        this.renderDialTexture(graphics, builder, texture, x, y);
        builder.setAlpha(0.6f * alpha);
        shaderInstance.safeGetUniform("Speed").set(800.0f);
        this.renderDialTexture(graphics, builder, texture, x - 1, y);
        this.renderDialTexture(graphics, builder, texture, x + 1, y);
        this.renderDialTexture(graphics, builder, texture, x, y - 1);
        this.renderDialTexture(graphics, builder, texture, x, y + 1);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public void renderDialTexture(GuiGraphics graphics, VFXBuilders.ScreenVFXBuilder builder, ResourceLocation texture, int x, int y) {
        builder.setTexture(texture).setPositionWithWidth((float)x, (float)y, (float)this.interfaceWidth, (float)this.interfaceHeight).blit(graphics.pose());
    }
}

