/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.banner;

import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;

public class SoulwovenBannerBlockEntity
extends LodestoneBlockEntity {
    public SpiritArcanaType spirit;
    public SoulwovenBannerPatternDataComponent patternData = SoulwovenBannerPatternDataComponent.DEFAULT;
    public boolean intense;

    public SoulwovenBannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MalumBlockEntities.SOULWOVEN_BANNER.get(), pos, state);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)this.patternData);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.patternData = (SoulwovenBannerPatternDataComponent)componentInput.get(MalumDataComponents.SOULWOVEN_BANNER_PATTERN);
    }

    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Item item = pStack.getItem();
            if (item instanceof SpiritShardItem) {
                SpiritShardItem shardItem = (SpiritShardItem)item;
                if (this.spirit != null && shardItem.matches(this.spirit) && this.intense) {
                    return super.onUseWithItem(pPlayer, pStack, pHand);
                }
                if (shardItem.matches(MalumSpiritTypes.UMBRAL_SPIRIT)) {
                    return super.onUseWithItem(pPlayer, pStack, pHand);
                }
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
                this.setSpirit(serverLevel, shardItem.getSpirit());
                pPlayer.swing(pHand, true);
            }
            if (pStack.canPerformAction(ItemAbilities.SHEARS_DISARM) && this.spirit != null) {
                this.setSpirit(serverLevel, null);
                pPlayer.swing(pHand, true);
            }
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.spirit != null) {
            this.spirit.save(tag);
        }
        tag.putBoolean("intense", this.intense);
        this.patternData.save(tag);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.spirit = SpiritArcanaType.load(tag).orElse(null);
        this.intense = tag.getBoolean("intense");
        this.patternData = SoulwovenBannerPatternDataComponent.load(tag);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("pattern");
    }

    public void setSpirit(ServerLevel level, @Nullable SpiritArcanaType newSpirit) {
        MalumNetworkedParticleEffectType effectType = newSpirit != null ? MalumParticleEffectTypes.APPLY_SOULWOVEN_BANNER_GLOW : MalumParticleEffectTypes.REMOVE_SOULWOVEN_BANNER_GLOW;
        NetworkedParticleEffectType.ParticleEffectBuilder particle = effectType.createEffect(this.worldPosition);
        if (newSpirit != null) {
            particle.color(newSpirit);
        } else if (this.spirit != null) {
            particle.color(this.spirit);
        }
        particle.spawn(level);
        this.intense = this.spirit == newSpirit;
        this.spirit = newSpirit;
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        level.playSound(null, this.worldPosition, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
    }
}

