/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel;

import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlock;
import com.sammy.malum.common.block.curiosities.redstone.OpenStateBlockEntity;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.NBTHelper;

public class WindTunnelBlockEntity
extends AbstractGustGizmoBlockEntity {
    private BlockPos igniterPos;

    public WindTunnelBlockEntity(BlockEntityType<? extends WindTunnelBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractGustGizmoBlockEntity>)type, pos, state);
    }

    public WindTunnelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends WindTunnelBlockEntity>)((BlockEntityType)MalumBlockEntities.WIND_TUNNEL.get()), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.igniterPos != null) {
            tag.put("igniterPos", (Tag)NBTHelper.saveBlockPos((BlockPos)this.igniterPos));
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.igniterPos = NBTHelper.readBlockPos((CompoundTag)pTag.getCompound("igniterPos"));
    }

    @Override
    public void setInfo(AbstractGustGizmoBlockEntity.GustGizmoInfo info) {
        this.getIgniter().ifPresent(g -> g.setInfo(info));
    }

    @Override
    public OpenStateBlockEntity.InboundInfo<? extends OpenStateBlockEntity> resetState() {
        if (this.getIgniter().isEmpty()) {
            return new AbstractGustGizmoBlockEntity.GustGizmoInfo(0, false);
        }
        return this.getIgniter().get().resetState();
    }

    @Override
    public boolean canTinker() {
        return this.getIgniter().isPresent();
    }

    @Override
    public OpenStateBlockEntity getTinkeredBlock() {
        Optional<GustIgniterBlockEntity> optional = this.getIgniter();
        if (optional.isPresent()) {
            return optional.get();
        }
        return super.getTinkeredBlock();
    }

    public void onBreak(@Nullable Player player) {
        Optional<GustIgniterBlockEntity> optional = this.getIgniter();
        if (optional.isPresent()) {
            GustIgniterBlockEntity igniter = optional.get();
            this.level.scheduleTick(this.igniterPos, igniter.getBlockState().getBlock(), 2);
        }
    }

    public boolean isActive() {
        return WindTunnelBlock.isActive(this.getBlockState());
    }

    public Optional<GustIgniterBlockEntity> getIgniter() {
        if (this.igniterPos == null) {
            return Optional.empty();
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.igniterPos);
        if (blockEntity instanceof GustIgniterBlockEntity) {
            GustIgniterBlockEntity igniter = (GustIgniterBlockEntity)blockEntity;
            return Optional.of(igniter);
        }
        return Optional.empty();
    }

    public boolean canIgnite(GustIgniterBlockEntity igniter) {
        if (this.igniterPos == null) {
            return true;
        }
        return igniter.getBlockPos().equals((Object)this.igniterPos);
    }

    public int getTunnelLength() {
        return this.getIgniter().map(GustIgniterBlockEntity::getTunnelLength).orElse(0);
    }

    public boolean isModified() {
        return this.getIgniter().map(i -> i.modified).orElse(false);
    }

    public void bind(GustIgniterBlockEntity igniter) {
        this.igniterPos = igniter.getBlockPos();
    }

    public void unbind() {
        this.igniterPos = null;
    }

    public int findLimit(int igniterStrength) {
        int limiter;
        Direction direction = (Direction)this.getBlockState().getValue((Property)WindTunnelBlock.FACING);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos next = new BlockPos.MutableBlockPos();
        for (limiter = 0; limiter < igniterStrength; ++limiter) {
            mutable.set((Vec3i)this.getBlockPos()).move(direction, limiter);
            next.set((Vec3i)mutable).move(direction);
            boolean canRender = Block.shouldRenderFace((BlockState)this.getBlockState(), (BlockGetter)this.level, (BlockPos)mutable, (Direction)direction, (BlockPos)next);
            if (!canRender) break;
        }
        return limiter;
    }
}

