/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class TotemPoleBlock<T extends TotemPoleBlockEntity>
extends LodestoneEntityBlock<T> {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final SpiritTypeProperty SPIRIT_TYPE = SpiritTypeProperty.SPIRIT_TYPE;
    protected final Supplier<? extends Block> logBlock;
    protected final boolean isSoulwood;

    public TotemPoleBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> logBlock, boolean isSoulwood) {
        super(properties.lootFrom(logBlock));
        this.logBlock = logBlock;
        this.isSoulwood = isSoulwood;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)SPIRIT_TYPE, (Comparable)((Object)"sacred")));
    }

    public Block getLogBlock() {
        return this.logBlock.get();
    }

    public boolean isSoulwood() {
        return this.isSoulwood;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity totemPole = (TotemPoleBlockEntity)blockEntity;
            return totemPole.spirit.getAnalogSignal();
        }
        return 0;
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return this.logBlock.get().getCloneItemStack(world, pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING, SPIRIT_TYPE});
    }

    public static BlockState createTotemPoleState(TotemPoleBlock<?> totemPole, Direction direction, SpiritLike spiritType) {
        return (BlockState)SpiritTypeProperty.setSpiritType(totemPole.defaultBlockState(), spiritType).setValue((Property)HORIZONTAL_FACING, (Comparable)direction);
    }
}

