/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem.anchor;

import com.sammy.malum.common.block.curiosities.totem.RiteSparkInteractable;
import com.sammy.malum.common.block.curiosities.totem.anchor.RiteAnchorBlock;
import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class RiteAnchorBlockEntity
extends LodestoneBlockEntity
implements RiteSparkInteractable {
    private static final int WARMUP_DURATION = 20;
    public static final HashMap<Holder<SpiritArcanaType>, Consumer<BlockRiteEffectActivatorEntity>> EFFECTS = new HashMap();
    public static final StringRepresentable.EnumCodec<AimState> CODEC;
    protected SpiritArcanaType spirit;
    protected int visualEffectStrength;
    protected AimState aimDirection;

    public RiteAnchorBlockEntity(BlockEntityType<? extends RiteAnchorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RiteAnchorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends RiteAnchorBlockEntity>)((BlockEntityType)MalumBlockEntities.RITE_ANCHOR.get()), pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registryLookup) {
        if (this.spirit != null) {
            this.spirit.save(compound);
        }
        if (this.aimDirection != null) {
            compound.putString("aimDirection", this.aimDirection.name);
        }
        compound.putInt("visualEffectStrength", this.visualEffectStrength);
        super.saveAdditional(compound, registryLookup);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.spirit = SpiritArcanaType.load(compound).orElse(null);
        this.aimDirection = compound.contains("aimDirection") ? (AimState)CODEC.byName(compound.getString("aimDirection")) : null;
        this.visualEffectStrength = compound.getInt("visualEffectStrength");
        super.loadAdditional(compound, registries);
    }

    public void commonTick(Level level) {
        if (this.spirit != null) {
            if (((Boolean)this.getBlockState().getValue((Property)RiteAnchorBlock.POWERED)).booleanValue()) {
                if (this.visualEffectStrength > 5) {
                    --this.visualEffectStrength;
                }
                return;
            }
            if (this.visualEffectStrength < 20) {
                ++this.visualEffectStrength;
            }
        }
    }

    @Override
    public void travel(ServerLevel level, BlockRiteEffectActivatorEntity spark) {
        if (((Boolean)this.getBlockState().getValue((Property)RiteAnchorBlock.POWERED)).booleanValue()) {
            return;
        }
        if (this.spirit != null) {
            Holder<SpiritArcanaType> holder = this.spirit.getHolder();
            Consumer<BlockRiteEffectActivatorEntity> effect = EFFECTS.get(holder);
            if (effect != null) {
                effect.accept(spark);
            }
            if (this.aimDirection.data2d != -1) {
                Direction direction = Direction.from2DDataValue((int)this.aimDirection.data2d);
                spark.updateDirection(direction);
                this.notifyObservers();
                this.playSound((SoundEvent)MalumSoundEvents.SPARK_DIRECTED.get());
                MalumParticleEffectTypes.RITE_ANCHOR_EFFECT.createEffect(this.getBlockPos().above()).color(this.spirit).spawn(level);
            }
        }
    }

    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        ServerLevel serverLevel;
        Level level;
        if (pStack.is(MalumTags.ItemTags.IS_TOTEMIC_TOOL) && (level = this.level) instanceof ServerLevel && this.updateAimDirection(serverLevel = (ServerLevel)level, pPlayer)) {
            BlockStateHelper.updateState((Level)this.level, (BlockPos)this.worldPosition);
            return ItemInteractionResult.SUCCESS;
        }
        level = pStack.getItem();
        if (level instanceof SpiritShardItem) {
            SpiritShardItem shard = (SpiritShardItem)level;
            if (this.spirit != null && shard.matches(this.spirit)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Level level2 = this.level;
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel2 = (ServerLevel)level2;
                SpiritArcanaType spirit = shard.getSpirit();
                this.setSpirit(serverLevel2, pPlayer, spirit);
                if (!pPlayer.isCreative() && !spirit.matches(MalumSpiritTypes.UMBRAL_SPIRIT)) {
                    pStack.shrink(1);
                }
                BlockStateHelper.updateState((Level)this.level, (BlockPos)this.worldPosition);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    public SpiritArcanaType getSpirit() {
        return this.spirit;
    }

    public AimState getAimDirection() {
        return this.aimDirection;
    }

    public float getGlowDelta() {
        return (float)this.visualEffectStrength / 20.0f;
    }

    public void setSpirit(ServerLevel level, Player player, SpiritArcanaType spirit) {
        this.updateAimDirection(level, player);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        level.playSound(null, this.worldPosition, SoundEvents.DEEPSLATE_BRICKS_PLACE, SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        this.visualEffectStrength = 0;
        this.spirit = spirit;
        level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)level.getBlockState(this.worldPosition)));
    }

    public boolean updateAimDirection(ServerLevel level, Player player) {
        AimState old = this.aimDirection;
        this.aimDirection = AimState.fromDirection(player.getDirection());
        return old != this.aimDirection;
    }

    static {
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.SACRED_SPIRIT, BlockRiteEffectActivatorEntity::recoverHealth);
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.WICKED_SPIRIT, BlockRiteEffectActivatorEntity::leechHealth);
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.ELDRITCH_SPIRIT, BlockRiteEffectActivatorEntity::duplicate);
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.AERIAL_SPIRIT, e -> e.upgrade(e.speed));
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.AQUEOUS_SPIRIT, e -> e.upgrade(e.potency));
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.EARTHEN_SPIRIT, e -> e.upgrade(e.impact));
        EFFECTS.put((Holder<SpiritArcanaType>)MalumSpiritTypes.INFERNAL_SPIRIT, e -> e.upgrade(e.distance));
        CODEC = StringRepresentable.fromEnum(AimState::values);
    }

    public static enum AimState implements StringRepresentable
    {
        NORTH("north", 2),
        SOUTH("south", 0),
        WEST("west", 1),
        EAST("east", 3),
        PUSH("push", -1),
        PULL("pull", -1);

        public final String name;
        public final int data2d;

        private AimState(String name, int data2d) {
            this.name = name;
            this.data2d = data2d;
        }

        public String getName() {
            return this.name;
        }

        public int getData2d() {
            return this.data2d;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static AimState fromDirection(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
                case Direction.UP -> PUSH;
                case Direction.DOWN -> PULL;
            };
        }
    }
}

