/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.nature;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.nature.IGradientedLeavesBlock;
import com.sammy.malum.registry.common.item.MalumItems;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MalumLeavesBlock
extends LeavesBlock
implements IGradientedLeavesBlock {
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)4);
    public final Color maxColor;
    public final Color minColor;

    public MalumLeavesBlock(BlockBehaviour.Properties properties, Color maxColor, Color minColor) {
        super(properties);
        this.maxColor = maxColor;
        this.minColor = minColor;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, COLOR, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)COLOR, (Comparable)Integer.valueOf(0));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        if (stack.getItem().equals(MalumItems.INFERNAL_SPIRIT.get())) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(((Integer)state.getValue((Property)COLOR) + 1) % 5)));
            player.swing(handIn);
            player.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.5f + MalumMod.RANDOM.nextFloat() * 0.5f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, hitResult);
    }

    @Override
    public Color getMaxColor() {
        return this.maxColor;
    }

    @Override
    public Color getMinColor() {
        return this.minColor;
    }
}

