/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.SoundHelper;

public class SoulWardData {
    public static Codec<SoulWardData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.DOUBLE.optionalFieldOf("soulWard", (Object)0.0).forGetter(SoulWardData::getSoulWard), (App)Codec.INT.optionalFieldOf("soulWardProgress", (Object)0).forGetter(SoulWardData::getSoulWardCooldown), (App)Codec.FLOAT.optionalFieldOf("appliedCooldownMultiplier", (Object)Float.valueOf(1.0f)).forGetter(SoulWardData::getAppliedCooldownMultiplier)).apply((Applicative)obj, SoulWardData::new));
    public static StreamCodec<ByteBuf, SoulWardData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private double soulWard;
    private int soulWardCooldown;
    private float appliedCooldownMultiplier = 1.0f;
    private boolean isDirty;

    public SoulWardData() {
    }

    public SoulWardData(double soulWard, int soulWardCooldown, float appliedCooldownMultiplier) {
        this.soulWard = soulWard;
        this.soulWardCooldown = soulWardCooldown;
        this.appliedCooldownMultiplier = appliedCooldownMultiplier;
    }

    public void tickData(LivingEntity living) {
        AttributeInstance attribute = living.getAttribute(MalumAttributes.SOUL_WARD_CAPACITY);
        if (attribute != null) {
            if (this.getSoulWard() < attribute.getValue()) {
                if (this.soulWardCooldown > 0) {
                    --this.soulWardCooldown;
                    this.tryCorrectCooldown(living);
                }
                if (this.soulWardCooldown <= 0) {
                    this.recoverSoulWard(living, 1.0);
                }
            }
            if (this.getSoulWard() > attribute.getValue()) {
                this.setSoulWard(attribute.getValue());
            }
        }
        if (this.isDirty) {
            if (!living.level().isClientSide) {
                living.syncData(MalumAttachmentTypes.SOUL_WARD);
            }
            this.isDirty = false;
        }
    }

    public void recoverSoulWard(LivingEntity entity, double amount) {
        AttributeInstance attribute = entity.getAttribute(MalumAttributes.SOUL_WARD_CAPACITY);
        if (this.getSoulWard() < attribute.getValue()) {
            Player player;
            Double multiplier = Optional.ofNullable(entity.getAttribute(MalumAttributes.SOUL_WARD_RECOVERY_GAIN)).map(AttributeInstance::getValue).orElse(1.0);
            double previousSoulward = this.soulWard;
            this.addSoulWard(amount * multiplier);
            if (!(!(this.soulWard > previousSoulward) || entity instanceof Player && (player = (Player)entity).isCreative())) {
                DeferredHolder<SoundEvent, SoundEvent> sound = this.soulWard >= attribute.getValue() ? MalumSoundEvents.SOUL_WARD_FULLY_CHARGED : MalumSoundEvents.SOUL_WARD_GROW;
                double pitchOffset = this.soulWard / attribute.getValue() * 0.5 + (double)((float)(Mth.ceil((double)this.soulWard) % 3) * 0.25f);
                SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)sound.get()), (float)0.25f, (float)((float)(1.0 + pitchOffset)));
            }
        }
        this.addCooldown(entity, 1.0f);
    }

    public void addSoulWard(double added) {
        this.setSoulWard(this.soulWard + added);
    }

    public void reduceSoulWard(double removed) {
        this.setSoulWard(this.soulWard - removed);
    }

    public void setSoulWard(double soulWard) {
        this.soulWard = Math.max(soulWard, 0.0);
        this.isDirty = true;
    }

    public void tryCorrectCooldown(LivingEntity entity) {
        double newCooldown = this.getSoulWardCooldown(entity) * this.appliedCooldownMultiplier;
        if ((double)this.soulWardCooldown > newCooldown) {
            this.soulWardCooldown = Mth.floor((double)newCooldown);
            this.isDirty = true;
        }
    }

    public void addCooldown(LivingEntity entity, float multiplier) {
        double newCooldown = this.getSoulWardCooldown(entity) * multiplier;
        if ((double)this.soulWardCooldown < newCooldown) {
            this.soulWardCooldown = Mth.floor((double)newCooldown);
            this.appliedCooldownMultiplier = multiplier;
            this.isDirty = true;
        }
    }

    public double getSoulWard() {
        return this.soulWard;
    }

    public int getSoulWardCooldown() {
        return this.soulWardCooldown;
    }

    public float getAppliedCooldownMultiplier() {
        return this.appliedCooldownMultiplier;
    }

    public boolean isDepleted() {
        return this.soulWard <= 0.0;
    }

    public float getSoulWardCooldown(LivingEntity entity) {
        double recoveryRate = entity.getAttributeValue(MalumAttributes.SOUL_WARD_RECOVERY_RATE);
        Integer cooldownDuration = (Integer)CommonConfig.SOUL_WARD_RATE.getConfigValue();
        return Mth.floor((double)((double)cooldownDuration.intValue() / recoveryRate));
    }
}

