/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.effect.ascension;

import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import team.lodestar.lodestone.helpers.ColorHelper;

public class LiftedEffect
extends MobEffect {
    public LiftedEffect() {
        super(MobEffectCategory.BENEFICIAL, ColorHelper.getColor((Color)MalumSpiritTypes.AERIAL_COLORS().primaryColor()));
    }

    public static double modifyVelocity(LivingEntity entity, double original) {
        MobEffectInstance effectInstance = entity.getEffect(MalumMobEffects.LIFTED);
        if (effectInstance != null) {
            int amplifier = effectInstance.getAmplifier();
            float limit = 0.2f / (float)(amplifier + 1);
            return Math.max(original, (double)(-limit));
        }
        return original;
    }

    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = entity.getEffect(MalumMobEffects.LIFTED);
        if (effectInstance != null) {
            event.setDistance(event.getDistance() / (float)(10 + effectInstance.getAmplifier() * 2));
            entity.removeEffect(MalumMobEffects.LIFTED);
        }
    }
}

