/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.effect.rite.aura.soulwood;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import team.lodestar.lodestone.helpers.ColorHelper;

public class SkyTetherEffect
extends MobEffect {
    public SkyTetherEffect() {
        super(MobEffectCategory.BENEFICIAL, ColorHelper.getColor((Color)MalumSpiritTypes.AERIAL_COLORS().primaryColor()));
        ResourceLocation id = MalumMod.malumPath("sky_tether");
        this.addAttributeModifier(Attributes.GRAVITY, id, -0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.JUMP_STRENGTH, id, 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = entity.getEffect(MalumMobEffects.SKY_TETHER);
        if (effectInstance != null) {
            int offset = 4 + effectInstance.getAmplifier() * 2;
            event.setDistance(event.getDistance() / (float)offset);
        }
    }
}

