/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class MovingEntity
extends Entity {
    public MovingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = false;
    }

    public void tick() {
        this.baseTick();
        this.applyMovement();
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = Math.sqrt(x * x + z * z);
            this.setXRot((float)(Mth.atan2((double)y, (double)d0) * 180.0 / 3.1415927410125732));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 180.0 / 3.1415927410125732));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    public boolean isPickable() {
        return true;
    }

    public abstract float getFriction();

    protected void applyMovement() {
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        float friction = this.getFriction();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            friction *= 0.825f;
        }
        this.setDeltaMovement(vec3.scale((double)friction));
        this.applyGravity();
        this.setPos(d0, d1, d2);
    }

    public void updateRotation() {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = vec3.horizontalDistance();
        this.setXRot(MovingEntity.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732)));
        this.setYRot(MovingEntity.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732)));
    }

    public static float lerpRotation(float currentRotation, float targetRotation) {
        while (targetRotation - currentRotation < -180.0f) {
            currentRotation -= 360.0f;
        }
        while (targetRotation - currentRotation >= 180.0f) {
            currentRotation += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)currentRotation, (float)targetRotation);
    }
}

