/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.activator;

import com.sammy.malum.common.block.curiosities.totem.RiteSparkInteractable;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.entity.MovingEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumEntityDataSerializers;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.NBTHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class BlockRiteEffectActivatorEntity
extends MovingEntity {
    public final TrailPointBuilder trail = TrailPointBuilder.create((int)6);
    public final TrailPointBuilder longTrail = TrailPointBuilder.create((int)20);
    protected static final EntityDataAccessor<SpiritArcanaType> DATA_SPIRIT_GLOW = SynchedEntityData.defineId(BlockRiteEffectActivatorEntity.class, (EntityDataSerializer)((EntityDataSerializer)MalumEntityDataSerializers.SPIRIT_ARCANA.get()));
    protected SpiritRiteBlockEffect effect;
    protected int upgradeSlots;
    public final RiteSparkAttributeData speed = new RiteSparkAttributeData(RiteSparkAttributeDataType.SPEED);
    public final RiteSparkAttributeData potency = new RiteSparkAttributeData(RiteSparkAttributeDataType.POTENCY);
    public final RiteSparkAttributeData impact = new RiteSparkAttributeData(RiteSparkAttributeDataType.IMPACT);
    public final RiteSparkAttributeData distance = new RiteSparkAttributeData(RiteSparkAttributeDataType.MAX_DISTANCE);
    public final List<RiteSparkAttributeData> attributes = List.of(this.speed, this.potency, this.impact, this.distance);
    protected BlockPos sourcePosition;
    protected BlockPos activationPosition;
    protected Direction movementDirection;
    protected int blockCounter;
    protected int totalBlocksTraveled;
    protected int age;
    protected int healDuration;
    protected int healCounter;
    protected int copyCounter;

    public BlockRiteEffectActivatorEntity(Level level) {
        super((EntityType)MalumEntities.RITE_BLOCK_EFFECT_ACTIVATOR.get(), level);
    }

    public BlockRiteEffectActivatorEntity(Level level, SpiritRiteBlockEffect effect, BlockPos sourcePosition, Direction movementDirection) {
        this(level);
        this.effect = effect;
        this.sourcePosition = sourcePosition;
        this.activationPosition = sourcePosition;
        this.movementDirection = movementDirection;
        this.upgradeSlots = 4;
        this.setPos(sourcePosition.getBottomCenter().add(0.0, (double)0.05f, 0.0));
        this.updateMotion();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SPIRIT_GLOW, (Object)((SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get()));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        SpiritArcanaType spirit = this.getSpiritType();
        if (spirit != null) {
            spirit.save(pCompound);
        }
        if (this.effect != null) {
            this.effect.save(pCompound);
        }
        pCompound.putInt("upgradeSlots", this.upgradeSlots);
        this.attributes.forEach(a -> a.save(pCompound));
        if (this.sourcePosition != null) {
            pCompound.put("sourcePosition", (Tag)NBTHelper.saveBlockPos((BlockPos)this.sourcePosition));
        }
        if (this.activationPosition != null) {
            pCompound.put("activationPosition", (Tag)NBTHelper.saveBlockPos((BlockPos)this.activationPosition));
        }
        if (this.movementDirection != null) {
            pCompound.putInt("movementDirection", this.movementDirection.ordinal());
        }
        pCompound.putInt("blockCounter", this.blockCounter);
        pCompound.putInt("blocksTraveled", this.totalBlocksTraveled);
        pCompound.putInt("age", this.age);
        pCompound.putInt("healDuration", this.healDuration);
        pCompound.putInt("healCounter", this.healCounter);
        pCompound.putInt("copyCounter", this.copyCounter);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        this.setSpirit(SpiritArcanaType.load(pCompound).orElse((SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get()));
        this.effect = SpiritRiteEntityEffect.CODEC.load(pCompound, SpiritRiteBlockEffect.class).orElse(null);
        this.upgradeSlots = pCompound.getInt("upgradeSlots");
        this.attributes.forEach(a -> a.load(pCompound));
        this.sourcePosition = NBTHelper.readBlockPos((CompoundTag)pCompound.getCompound("sourcePosition"));
        this.activationPosition = NBTHelper.readBlockPos((CompoundTag)pCompound.getCompound("activationPosition"));
        this.movementDirection = Direction.values()[pCompound.getInt("movementDirection")];
        this.blockCounter = pCompound.getInt("blockCounter");
        this.totalBlocksTraveled = pCompound.getInt("blocksTraveled");
        this.age = pCompound.getInt("age");
        this.healDuration = pCompound.getInt("healDuration");
        this.healCounter = pCompound.getInt("healCounter");
        this.copyCounter = pCompound.getInt("copyCounter");
    }

    @Override
    public void tick() {
        this.updateMotion();
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.notifyTotem();
            if (this.healDuration > 0) {
                --this.healDuration;
                return;
            }
            if (this.updatePosition()) {
                if (this.activationPosition == this.sourcePosition) {
                    return;
                }
                Level level2 = this.level();
                BlockPos affectedPos = this.activationPosition.below();
                boolean canTriggerEffect = true;
                BlockEntity blockEntity = level2.getBlockEntity(affectedPos);
                if (blockEntity instanceof RiteSparkInteractable) {
                    RiteSparkInteractable interactable = (RiteSparkInteractable)blockEntity;
                    interactable.travel(serverLevel, this);
                    canTriggerEffect = false;
                } else if (level2.getBlockState(affectedPos).is(MalumTags.BlockTags.IS_RITE_IMMUNE)) {
                    canTriggerEffect = false;
                }
                if (canTriggerEffect) {
                    if ((float)this.blockCounter >= this.distance.getValue()) {
                        this.discard();
                        return;
                    }
                    if (this.triggerRiteEffect(serverLevel, affectedPos)) {
                        ++this.blockCounter;
                    }
                }
                ++this.totalBlocksTraveled;
            }
        }
        if (this.level().isClientSide) {
            Vec3 position = this.getPosition(0.5f);
            this.trail.addTrailPoint(position);
            this.longTrail.addTrailPoint(position);
            this.trail.tickTrailPoints();
            this.longTrail.tickTrailPoints();
            if (this.level().getGameTime() % 3L == 0L) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.position(), this.getSpiritType());
                lightSpecs.getBuilder().modifyScaleData(d -> d.multiplyValue(1.5f)).multiplyLifetime(2.0f);
                lightSpecs.getBloomBuilder().multiplyLifetime(2.0f);
                lightSpecs.spawnParticles();
            }
        }
        ++this.age;
    }

    @Override
    public float getFriction() {
        return 1.0f;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    public boolean triggerRiteEffect(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        this.effect.applyEffect(level, this, state, pos, this.impact.getValue());
        return true;
    }

    public void upgrade(RiteSparkAttributeData target) {
        if (this.upgradeSlots > 0 && target.increase()) {
            --this.upgradeSlots;
        }
    }

    public void recoverHealth() {
        if (this.blockCounter > 0) {
            ++this.healCounter;
            if (this.healCounter > 4) {
                return;
            }
            this.healDuration = Mth.floor((float)((float)(this.blockCounter * 4) / this.potency.getValue()));
            this.blockCounter = 0;
            this.updateMotion();
        }
    }

    public void leechHealth() {
        if (this.blockCounter > 0) {
            ++this.healCounter;
            if (this.healCounter > 4) {
                return;
            }
            this.blockCounter = 0;
            for (RiteSparkAttributeData attribute : this.attributes) {
                if (!attribute.decrease()) continue;
                return;
            }
        }
    }

    public void duplicate() {
        if (this.copyCounter == -1 || this.copyCounter >= 4) {
            return;
        }
        BlockRiteEffectActivatorEntity doppelganger = new BlockRiteEffectActivatorEntity(this.level(), this.effect, this.activationPosition, this.movementDirection);
        CompoundTag data = new CompoundTag();
        this.addAdditionalSaveData(data);
        doppelganger.readAdditionalSaveData(data);
        ++doppelganger.copyCounter;
        this.copyCounter = -1;
        this.level().addFreshEntity((Entity)doppelganger);
    }

    public void notifyTotem() {
        BlockEntity blockEntity;
        if (this.sourcePosition != null && (blockEntity = this.level().getBlockEntity(this.sourcePosition)) instanceof TotemBaseBlockEntity) {
            TotemBaseBlockEntity totemBase = (TotemBaseBlockEntity)blockEntity;
            totemBase.receiveSparkUpdate();
        }
    }

    public void updateDirection(Direction direction) {
        this.movementDirection = direction;
        this.updateMotion();
    }

    public void updateMotion() {
        if (this.movementDirection != null) {
            float rate = 0.2f * this.speed.getValue();
            if (this.healDuration > 0) {
                this.setDeltaMovement(Vec3.ZERO);
                return;
            }
            this.setDeltaMovement(new Vec3((double)((float)this.movementDirection.getStepX() * rate), (double)this.movementDirection.getStepY(), (double)((float)this.movementDirection.getStepZ() * rate)));
        }
    }

    public boolean updatePosition() {
        if (this.movementDirection == null) {
            return false;
        }
        float xOffset = (float)this.movementDirection.getStepX() * 0.5f;
        float zOffset = (float)this.movementDirection.getStepZ() * 0.5f;
        int i = Mth.floor((double)(this.getX() - (double)xOffset));
        int j = Mth.floor((double)this.getY());
        int k = Mth.floor((double)(this.getZ() - (double)zOffset));
        BlockPos centered = new BlockPos(i, j, k);
        if (this.activationPosition == null) {
            this.activationPosition = centered;
            return true;
        }
        if (i != this.activationPosition.getX() || j != this.activationPosition.getY() || k != this.activationPosition.getZ()) {
            this.activationPosition = centered;
            this.setPos((float)centered.getX() + 0.5f, (float)centered.getY() + 0.05f, (float)centered.getZ() + 0.5f);
            return true;
        }
        return false;
    }

    public float getVisualEffectScalar() {
        return Math.min((float)this.age / 10.0f, 1.0f);
    }

    public SpiritArcanaType getSpiritType() {
        return (SpiritArcanaType)this.getEntityData().get(DATA_SPIRIT_GLOW);
    }

    public void setSpirit(SpiritArcanaType spirit) {
        this.getEntityData().set(DATA_SPIRIT_GLOW, (Object)spirit);
    }

    public static class RiteSparkAttributeData {
        protected final RiteSparkAttributeDataType type;
        protected int tier;

        public RiteSparkAttributeData(RiteSparkAttributeDataType type, int tier) {
            this.type = type;
            this.tier = tier;
        }

        public RiteSparkAttributeData(RiteSparkAttributeDataType type) {
            this(type, 0);
        }

        public float getValue() {
            return this.type.getValue(this.tier);
        }

        public boolean increase() {
            if (this.tier < this.type.maxTier() - 1) {
                ++this.tier;
                return true;
            }
            return false;
        }

        public boolean decrease() {
            if (this.tier > 0) {
                --this.tier;
                return true;
            }
            return false;
        }

        public void save(CompoundTag compoundTag) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("tier", this.tier);
            compoundTag.put(this.type.name, (Tag)tag);
        }

        public void load(CompoundTag compoundTag) {
            if (compoundTag.contains(this.type.name)) {
                CompoundTag tag = compoundTag.getCompound(this.type.name);
                this.tier = tag.getInt("tier");
            }
        }
    }

    public record RiteSparkAttributeDataType(String name, int maxTier, List<Float> valuePerTier) {
        public static RiteSparkAttributeDataType SPEED = new RiteSparkAttributeDataType("speed", List.of(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)));
        public static RiteSparkAttributeDataType POTENCY = new RiteSparkAttributeDataType("potency", List.of(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)));
        public static RiteSparkAttributeDataType IMPACT = new RiteSparkAttributeDataType("impact", List.of(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)));
        public static RiteSparkAttributeDataType MAX_DISTANCE = new RiteSparkAttributeDataType("max_distance", List.of(Float.valueOf(8.0f), Float.valueOf(16.0f), Float.valueOf(32.0f)));

        public RiteSparkAttributeDataType(String name, List<Float> valuePerTier) {
            this(name, valuePerTier.size(), valuePerTier);
        }

        public float getValue(int tier) {
            if (tier < 0) {
                return this.valuePerTier.getFirst().floatValue() / (float)(Mth.abs((int)tier) + 1);
            }
            if (tier >= this.maxTier) {
                return 0.0f;
            }
            return this.valuePerTier.get(tier).floatValue();
        }
    }
}

