/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.activator;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemDestinationData;
import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class SpiritCollectionActivatorEntity
extends FloatingEntity {
    public final List<TrailPointBuilder> orbitingTrails = new ArrayList<TrailPointBuilder>(List.of(TrailPointBuilder.create((int)4), TrailPointBuilder.create((int)4)));
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);

    public SpiritCollectionActivatorEntity(Level level) {
        super((EntityType)MalumEntities.SPIRIT_COLLECTION_ACTIVATOR.get(), level);
        this.maxAge = 4000;
    }

    public SpiritCollectionActivatorEntity(Level level, UUID ownerUUID, Vec3 position, Vec3 velocity) {
        this(level);
        this.setDestination(new FloatingItemDestinationData(ownerUUID));
        this.setPos(position);
        this.setDeltaMovement(velocity);
        this.maxAge = 800;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public void collect(ServerLevel level) {
        this.getDestination().getEntityCollector(level).ifPresent(SoulHarvestHandler::triggerSpiritCollection);
        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SPIRIT_PICKUP.get()), (float)0.3f, (float)Mth.nextFloat((RandomSource)this.random, (float)1.2f, (float)1.5f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            float offsetScale = 0.1f + this.random.nextFloat() * 0.2f;
            Vec3 position = this.getOffsetPosition(0.5f);
            for (int i = 0; i < this.orbitingTrails.size(); ++i) {
                TrailPointBuilder trail = this.orbitingTrails.get(i);
                float scalar = (float)this.age / 6.0f;
                float offset = (float)i * 3.14f;
                float angle = this.spinOffset + scalar + offset;
                double xOffset = Math.sin(angle) * (double)offsetScale;
                double zOffset = Math.cos(angle) * (double)offsetScale;
                trail.addTrailPoint(position.add(xOffset, 0.0, zOffset));
                trail.tickTrailPoints();
            }
            Vec3 motion = this.getDeltaMovement();
            Vec3 norm = motion.normalize().scale((double)0.05f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.getOffsetPosition(), MalumSpiritTypes.UMBRAL_SPIRIT);
            lightSpecs.getBuilder().setMotion(norm);
            lightSpecs.getBloomBuilder().setMotion(norm);
            lightSpecs.spawnParticles();
        }
    }

    @Override
    public int getWindUpDuration() {
        return 25;
    }

    @Override
    public float getMovementEasing(float windUp, float distance) {
        return super.getMovementEasing(windUp, distance) * 4.0f;
    }

    @Override
    public float getFriction() {
        return 0.9f;
    }
}

