/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.ErosionScepterItem;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class DrainingBoltEntity
extends AbstractBoltProjectileEntity {
    public DrainingBoltEntity(Level level) {
        super((EntityType<? extends AbstractBoltProjectileEntity>)((EntityType)MalumEntities.DRAINING_BOLT.get()), level);
        this.noPhysics = false;
    }

    public DrainingBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = false;
    }

    @Override
    public void onDealDamage(LivingEntity target) {
        if (target.getRandom().nextFloat() < 0.3f) {
            MobEffectInstance effect = target.getEffect(MalumMobEffects.SILENCED);
            if (effect == null) {
                target.addEffect(new MobEffectInstance(MalumMobEffects.SILENCED, 150, 0, true, true, true));
            } else {
                EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)target, (int)1, (int)19);
                EntityHelper.extendEffect((MobEffectInstance)effect, (LivingEntity)target, (int)15, (int)300);
            }
        }
    }

    @Override
    public void playSound(SoundEvent pSound, float pVolume, float pPitch) {
        super.playSound(pSound, pVolume, pPitch - 0.2f);
        super.playSound((SoundEvent)MalumSoundEvents.DRAINING_MOTIF.get(), pVolume, pPitch - 0.1f);
    }

    @Override
    public int getMaxAge() {
        return 30;
    }

    @Override
    public float getOrbitingTrailDistance() {
        return 0.5f;
    }

    @Override
    public BoltImpactParticleEffect getImpactParticleEffect() {
        return MalumParticleEffectTypes.DRAINING_BOLT_IMPACT;
    }

    @Override
    public MalumNetworkedParticleEffectColorData getImpactParticleColor() {
        return new MalumNetworkedParticleEffectColorData(new ColorParticleDataWrapper[]{ErosionScepterItem.SCEPTER_COLOR_DATA});
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.EROSION_SCEPTER.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        Vec3 position = this.position();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, ErosionScepterItem.SCEPTER_COLOR_DATA);
        lightSpecs.getBuilder().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.spawnParticles();
        WorldParticleBuilder.create(MalumParticles.SAW).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)this.getDeltaMovement().normalize())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.3f * scalar), (float)(0.1f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(Math.min(6 + this.age * 3, 24)).setColorData((ColorParticleDataWrapper)ErosionScepterItem.SCEPTER_COLOR_DATA).setFriction(0.95f).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, position.x, position.y, position.z);
    }
}

