/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.UnwindingChaosStaffItem;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class EntropicFlameBoltEntity
extends AbstractBoltProjectileEntity {
    public TrailPointBuilder secondarySpinningTrailPointBuilder;

    public EntropicFlameBoltEntity(Level level) {
        super((EntityType<? extends AbstractBoltProjectileEntity>)((EntityType)MalumEntities.ENTROPIC_FLAME_BOLT.get()), level);
        this.noPhysics = false;
        this.trailPointBuilder = TrailPointBuilder.create((int)32);
        this.secondarySpinningTrailPointBuilder = TrailPointBuilder.create((int)24);
        this.spinningTrailPointBuilder = TrailPointBuilder.create((int)24);
    }

    public EntropicFlameBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = false;
    }

    @Override
    public float getOrbitingTrailDistance() {
        return 0.2f + this.random.nextFloat() * 0.4f;
    }

    @Override
    protected void onHitBlock(BlockHitResult pResult) {
        AABB boundingBox = this.getBoundingBox();
        this.setBoundingBox(boundingBox.deflate(0.25));
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitresult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitresult;
            super.onHitBlock(blockHitResult);
        }
        this.setBoundingBox(boundingBox);
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            livingentity.igniteForSeconds(4.0f);
        }
        super.onHitEntity(result);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.spawnDelay > 0) {
                return;
            }
            float offsetScale = this.fadingAway ? 0.0f : this.getOrbitingTrailDistance();
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + 3.14f + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + 3.14f + scalar) * (double)offsetScale;
                this.secondarySpinningTrailPointBuilder.addTrailPoint(position.add(xOffset, 0.0, zOffset));
            }
            this.secondarySpinningTrailPointBuilder.tickTrailPoints();
        }
    }

    @Override
    public void playSound(SoundEvent pSound, float pVolume, float pPitch) {
        super.playSound(pSound, pVolume, pPitch - 0.2f);
        super.playSound((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_LIGHT_IMPACT.get(), pVolume - 0.2f, pPitch + 0.5f);
        super.playSound((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_REVERB.get(), pVolume - 0.2f, pPitch + 0.5f);
    }

    @Override
    public int getMaxAge() {
        return 60;
    }

    @Override
    public BoltImpactParticleEffect getImpactParticleEffect() {
        return MalumParticleEffectTypes.ENTROPIC_BOLT_IMPACT;
    }

    @Override
    public MalumNetworkedParticleEffectColorData getImpactParticleColor() {
        return new MalumNetworkedParticleEffectColorData(new ColorParticleDataWrapper[]{UnwindingChaosStaffItem.AURIC_COLOR_DATA, MalumSpiritTypes.AQUEOUS_SPIRIT.createColorData().build()});
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.UNWINDING_CHAOS.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        Vec3 position = this.position();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, UnwindingChaosStaffItem.AURIC_COLOR_DATA);
        lightSpecs.getBuilder().modifyScaleData(d -> d.multiplyValue(3.0f * scalar)).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(2.5f).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).enableForcedSpawn().setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.5f).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setMotion(norm);
        lightSpecs.spawnParticles();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.98f));
        float min = Math.min(1.0f, 2.0f * scalar);
        WorldParticleBuilder.create(MalumParticles.GIANT_ARROW).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.8f * scalar), (float)(2.4f * scalar), (float)(0.1f * scalar)).setEasing(Easing.CUBIC_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.5f * min), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.2f * scalar), (float)(0.1f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(Math.min(2 + this.age, 16)).setColorData((ColorParticleDataWrapper)UnwindingChaosStaffItem.AURIC_COLOR_DATA).addTickActor(behavior).enableForcedSpawn().setMotion(norm).enableNoClip().spawn(level, position.x, position.y, position.z);
        WorldParticleBuilder.create(MalumParticles.GIANT_ARROW).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)(2.0f * scalar), (float)(2.8f * scalar), (float)(0.3f * scalar)).setEasing(Easing.CUBIC_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.6f * min), (float)(0.3f * min), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)EthericNitrateEntity.AURIC_RED, (Color)EthericNitrateEntity.AURIC_RED).setCoefficient(3.0f).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.5f * scalar), (float)(0.3f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setLifetime(Math.min(3 + this.age, 24)).setMotion(norm.scale(0.5)).addTickActor(behavior).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z);
    }
}

