/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.authority;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.EntityHelper;

public class GleefulTargetAuthority
extends GeasEffect {
    public GleefulTargetAuthority() {
        super((GeasEffectType)MalumGeasEffectTypes.AUTHORITY_OF_THE_GLEEFUL_TARGET.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("gleeful_target", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("gleeful_target_arcane_resonance", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, -0.75, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(MalumTags.DamageTypeTags.GLEEFUL_TARGET_BLACKLIST)) {
            return;
        }
        MobEffectInstance gleefulTarget = target.getEffect(MalumMobEffects.GLEEFUL_TARGET);
        int addedAmount = (int)(100.0 * target.getAttributeValue(MalumAttributes.ARCANE_RESONANCE));
        if (gleefulTarget == null) {
            target.addEffect(new MobEffectInstance(MalumMobEffects.GLEEFUL_TARGET, addedAmount * 4, 0, true, true, true));
        } else {
            EntityHelper.extendEffect((MobEffectInstance)gleefulTarget, (LivingEntity)target, (int)addedAmount, (int)36000);
        }
    }

    public static boolean pausePotionEffects(LivingEntity entity, MobEffectInstance instance) {
        if (instance.getEffect().equals(MalumMobEffects.GLEEFUL_TARGET)) {
            return false;
        }
        MobEffectInstance gleefulTarget = entity.getEffect(MalumMobEffects.GLEEFUL_TARGET);
        if (gleefulTarget != null) {
            MobEffect type = (MobEffect)instance.getEffect().value();
            return !type.isInstantenous();
        }
        return false;
    }
}

