/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aerial;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionKnockbackEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class CloudSkipperGeas
extends GeasEffect {
    protected static final float WARMUP_DURATION = 40.0f;
    protected int ascensionTime;

    public CloudSkipperGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_CLOUDSKIPPER.get());
    }

    public static void onExplosionKnockback(ExplosionKnockbackEvent event) {
        Entity entity;
        LivingEntity entity2;
        LivingEntity livingEntity;
        Explosion explosion = event.getExplosion();
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        Object object = event.getAffectedEntity();
        if (object instanceof LivingEntity) {
            livingEntity = (LivingEntity)object;
            entities.add(livingEntity);
        }
        if (explosion.getIndirectSourceEntity() != null) {
            entities.add(explosion.getIndirectSourceEntity());
        }
        if ((object = explosion.getDirectSourceEntity()) instanceof LivingEntity) {
            livingEntity = (LivingEntity)object;
            entities.add(livingEntity);
        }
        GeasEffect instance = null;
        object = entities.iterator();
        while (object.hasNext() && (instance = CloudSkipperGeas.getInstance(entity2 = (LivingEntity)object.next())) == null) {
        }
        if (instance instanceof CloudSkipperGeas && !explosion.damageCalculator.shouldDamageEntity(explosion, entity = event.getAffectedEntity())) {
            float minimumUpwardsVelocity = 0.5f;
            double horizontalScalar = 2.0;
            double verticalScalar = entity instanceof Player ? 1.25 : 1.75;
            Vec3 knockbackVelocity = event.getKnockbackVelocity();
            if (knockbackVelocity.y < (double)minimumUpwardsVelocity) {
                double length = knockbackVelocity.length();
                knockbackVelocity = knockbackVelocity.normalize().multiply(length, (double)minimumUpwardsVelocity, length);
            }
            event.setKnockbackVelocity(knockbackVelocity.multiply(horizontalScalar, verticalScalar, horizontalScalar));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.addEffect(new MobEffectInstance(MalumMobEffects.ASCENSION, 200, 3));
            }
        }
    }

    public static GeasEffect getInstance(LivingEntity entity) {
        return GeasEffectHandler.getGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_CLOUDSKIPPER);
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.onGround() || entity.isInWater() || entity.isInLava()) {
            if (this.ascensionTime > 0) {
                --this.ascensionTime;
            }
            return;
        }
        if (entity.hasEffect(MalumMobEffects.ASCENSION) || entity.hasEffect(MalumMobEffects.LIFTED)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.level().isClientSide) {
                    float delta;
                    Vec3 velocity = player.getDeltaMovement();
                    Vec3 angle = player.getLookAngle();
                    if (angle.y > (double)-0.6f && angle.y < (double)0.6f && (delta = (float)Math.clamp(velocity.y * 2.0, 0.0, 1.0)) > 0.0f) {
                        float target = (float)((double)0.2f + player.getAttributeValue(Attributes.MOVEMENT_SPEED)) * 0.45f;
                        Vec3 added = angle.scale((double)target).multiply((double)delta, 0.5, (double)delta);
                        player.setDeltaMovement(velocity.add(added).multiply((double)0.95f, 1.0, (double)0.95f));
                    }
                }
            }
            if ((float)this.ascensionTime < 40.0f) {
                ++this.ascensionTime;
            }
        }
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(DamageTypeTags.IS_FALL)) {
            event.setNewDamage(event.getNewDamage() * 2.0f);
        }
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("rocket_jumping", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("wind_gliding", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("weak_legs", new Object[0]));
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        float delta = Math.min((float)this.ascensionTime, 40.0f) / 40.0f;
        if (delta > 0.0f) {
            float modifier = 0.75f * delta;
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        return modifiers;
    }
}

