/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aerial;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.EntityHelper;

public class ContinuingShotGeas
extends GeasEffect {
    public static final int MAX_DRAW_SPEED_STACKS = 5;

    public ContinuingShotGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_CONTINUING_SHOT.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("faster_draw_time", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("missing_halts_draw_time", new Object[0]));
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        AbstractArrow arrow;
        Entity projectile = event.getSource().getDirectEntity();
        if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).isCritArrow() || projectile instanceof AbstractBoltProjectileEntity) {
            ContinuingShotGeas.applyEffect(attacker, true);
        }
    }

    public static void projectileHitBlock(Projectile projectile) {
        LivingEntity owner;
        Entity entity;
        if (projectile.level().isClientSide) {
            return;
        }
        if ((projectile instanceof AbstractArrow || projectile instanceof AbstractBoltProjectileEntity) && (entity = projectile.getOwner()) instanceof LivingEntity && GeasEffectHandler.hasGeasEffect(owner = (LivingEntity)entity, MalumGeasEffectTypes.PACT_OF_THE_CONTINUING_SHOT)) {
            ContinuingShotGeas.applyEffect(owner, false);
        }
    }

    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        LivingEntity entity = event.getEntity();
        GeasEffect geasEffect = GeasEffectHandler.getGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_CONTINUING_SHOT);
        if (geasEffect instanceof ContinuingShotGeas) {
            int duration = event.getDuration();
            int drawSpeedStacks = 0;
            MobEffectInstance positive = entity.getEffect(MalumMobEffects.TRUE_SHOT);
            MobEffectInstance negative = entity.getEffect(MalumMobEffects.FLAWED_AIM);
            if (positive != null) {
                drawSpeedStacks += positive.getAmplifier() + 1;
            }
            if (negative != null) {
                drawSpeedStacks -= negative.getAmplifier() + 1;
            }
            duration = drawSpeedStacks < 0 ? (duration -= drawSpeedStacks * 5) : (duration -= (int)((float)drawSpeedStacks * 1.5f));
            event.setDuration(duration);
        }
    }

    public static void applyEffect(LivingEntity entity, boolean isPositive) {
        entity.removeEffect(isPositive ? MalumMobEffects.FLAWED_AIM : MalumMobEffects.TRUE_SHOT);
        DeferredHolder<MobEffect, MobEffect> effect = isPositive ? MalumMobEffects.TRUE_SHOT : MalumMobEffects.FLAWED_AIM;
        MobEffectInstance instance = entity.getEffect(effect);
        if (instance == null) {
            entity.addEffect(new MobEffectInstance(effect, 200, 0, true, true, true));
        } else {
            EntityHelper.amplifyEffect((MobEffectInstance)instance, (LivingEntity)entity, (int)1, (int)4);
            EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)entity, (int)40, (int)400);
        }
    }
}

