/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aqueous;

import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class PatienceRepaidGeas
extends GeasEffect {
    private float bufferedDamage;
    private int damageTimer;

    public PatienceRepaidGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_PATIENCE_REPAID.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("buffered_damage", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("buffered_damage_non_lethal", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("buffered_damage_more_overall", new Object[0]));
    }

    public void incomingDamageEvent(LivingIncomingDamageEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.isCanceled() || event.getSource().is(MalumDamageTypes.KARMIC)) {
            return;
        }
        float half = event.getAmount() * 0.5f;
        event.setAmount(half);
        this.bufferedDamage += half * 1.2f;
    }

    public void incomingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(MalumDamageTypes.KARMIC)) {
            event.setCanceled(true);
            target.setHealth(1.0f);
        }
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.bufferedDamage > 0.0f) {
                ++this.damageTimer;
                float delta = Math.min(this.bufferedDamage / (entity.getMaxHealth() * 0.5f), 1.0f);
                int time = 100 - Mth.ceil((float)(delta * 80.0f));
                if (this.damageTimer > time) {
                    float percentage = 1.0f - delta * 0.8f;
                    float damage = this.bufferedDamage * percentage;
                    Vec3 velocity = entity.getDeltaMovement();
                    entity.hurt(DamageTypeHelper.create((Level)entity.level(), MalumDamageTypes.KARMIC), damage);
                    entity.setDeltaMovement(velocity);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
                    }
                    MalumParticleEffectTypes.PATIENCE_REPAID.createEffect((Entity)entity).color(new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT)).spawn(level2);
                    SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.PATIENT_DROWNING.get()), (SoundSource)entity.getSoundSource(), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)level2.random, (float)0.9f, (float)1.1f));
                    this.bufferedDamage -= damage;
                    this.damageTimer = 0;
                }
            }
        }
    }
}

