/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.earthen;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class LoneDruidGeas
extends GeasEffect {
    public float coverPercentage;

    public LoneDruidGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_LONE_DRUID.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        float bonus = (1.0f - this.coverPercentage) * 4.0f;
        if (bonus > 0.0f) {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ARMOR, 5.0f * bonus, AttributeModifier.Operation.ADD_VALUE);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, 2.0f * bonus, AttributeModifier.Operation.ADD_VALUE);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, 0.25f * bonus, AttributeModifier.Operation.ADD_VALUE);
        } else {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, -0.5, AttributeModifier.Operation.ADD_VALUE);
        }
        return modifiers;
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("no_armor_druid_armor", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("no_armor", new Object[0]));
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().getGameTime() % 40L == 0L) {
            float oldCoverPercentage = this.coverPercentage;
            this.coverPercentage = entity.getArmorCoverPercentage();
            if (this.coverPercentage > 0.0f) {
                WorldEventHandler.addWorldEvent((Level)entity.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)entity).setDamageData(0.0f, 2.0f, 4).setMagicDamageType(MalumDamageTypes.KARMIC));
            }
            if (oldCoverPercentage != this.coverPercentage) {
                this.setDirty();
            }
        }
    }
}

