/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.earthen;

import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.ModifyGluttonyPropertiesEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class ProfaneGluttonGeas
extends GeasEffect {
    public ProfaneGluttonGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PROFANE_GLUTTON.get());
    }

    @Override
    public void modifyGluttonyPropertiesEvent(ModifyGluttonyPropertiesEvent event, LivingEntity collector) {
        event.getProperties().scaleInitialAmplifier(4.0f).scaleAmplifierGain(2.0f).scaleAmplifierLimit(2.0f).replaceEffectType((Holder<MobEffect>)MalumMobEffects.DESPERATE_NEED);
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("desperate_need", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("desperate_need_scythe_proficiency", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("poison_slash", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("poison_slash_consumes_desperate_need", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("desperate_need_betrayal", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public void finalizedIncomingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (attacker == null) {
            if (event.getSource().is(DamageTypes.STARVE)) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 40, 1));
            }
            return;
        }
        MobEffectInstance effect = attacker.getEffect(MobEffects.POISON);
        if (effect == null) {
            return;
        }
        MobEffectInstance copy = new MobEffectInstance(effect);
        copy.duration = Math.min(copy.duration, 30);
        target.addEffect(copy);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            MobEffectInstance effect = attacker.getEffect(MalumMobEffects.DESPERATE_NEED);
            if (effect == null) {
                return;
            }
            DamageSource source = event.getSource();
            RandomSource random = attacker.getRandom();
            if (source.is(MalumDamageTypes.DESPERATE_NEED_CUT)) {
                int amplifier = effect.getAmplifier();
                int consumedStacks = 1 + amplifier / 6;
                if (consumedStacks >= amplifier) {
                    attacker.removeEffect(MalumMobEffects.DESPERATE_NEED);
                } else {
                    effect.amplifier -= consumedStacks;
                    EntityHelper.syncEffect((MobEffectInstance)effect, (LivingEntity)attacker);
                }
                int poisonDuration = 40;
                int poisonStrength = 1 + amplifier;
                target.addEffect(new MobEffectInstance(MobEffects.POISON, poisonDuration, poisonStrength, false, true, true));
                WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.SCYTHE_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).tiedToTarget().forwardOffset(-2.0f).upwardOffset(-0.5f).color(MalumSpiritTypes.EARTHEN_SPIRIT).mirroredRandomly(random);
                if (MalumScytheItem.canSweep(attacker)) {
                    MalumScytheItem.trySweep(attacker, target, event.getNewDamage());
                } else {
                    particle.verticalSlashRotation();
                }
                particle.slashRotation(particle.getSlashRotation() + RandomHelper.randomBetween((RandomSource)random, (float)-0.8f, (float)0.8f));
                particle.spawn(level2);
                return;
            }
            if (source.is(MalumTags.DamageTypeTags.IS_SCYTHE)) {
                MalumScytheItem.ScytheDamage damage = MalumScytheItem.getScytheDamage(source, attacker);
                float physicalDamage = damage.physicalDamage();
                float magicDamage = damage.magicDamage();
                float damageScalar = 0.5f;
                int delay = 2;
                float average = (physicalDamage + magicDamage) / 2.0f;
                physicalDamage *= physicalDamage / average * damageScalar;
                magicDamage *= magicDamage / average * damageScalar;
                WorldEventHandler.addWorldEvent((Level)level2, (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker, source.getDirectEntity()).setDamageData(physicalDamage, magicDamage, delay).setPhysicalDamageType(MalumDamageTypes.DESPERATE_NEED_CUT).setSound((Holder<SoundEvent>)MalumSoundEvents.DESPERATE_NEED_CUT, 0.9f, 1.1f, 1.0f));
            }
        }
    }
}

