/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.infernal;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ProspectorGeas
extends GeasEffect {
    public ProspectorGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PROSPECTOR.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("ore_prospecting", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("avarice_healing", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("avarice_combustion", new Object[0]));
    }

    public void finalizedIncomingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level;
        MobEffectInstance effect;
        DamageSource source = event.getSource();
        if (!source.is(DamageTypeTags.IS_FIRE) && !source.is(DamageTypeTags.IS_EXPLOSION) && (effect = target.getEffect(MalumMobEffects.AVARICE)) != null && (level = target.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            target.igniteForSeconds((float)(effect.amplifier + 1) * 0.5f);
            MalumParticleEffectTypes.PROSPECTORS_STREAK_BURN.createEffect((Entity)target).color(new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.INFERNAL_SPIRIT)).spawn(level2);
        }
    }

    public static boolean hasProspectorPact(LivingEntity entity) {
        return GeasEffectHandler.hasGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_PROSPECTOR);
    }
}

